<?php

namespace App\Controllers;

use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
// use App\DAO\MySQL\CodeBD\NameDAO;
use App\DAO\MySQL\CodeBD\NoteCreditDAO;
use App\Models\MySQL\CodeyGenerateNoteCredit\NoteCreditModel;
use App\Models\MySQL\CodeyGenerateNoteCredit\NoteCreditItemsModel;
use App\Models\MySQL\CodeyGenerateNoteCredit\NoteCreditModelSendInvoice;

final class CreditNoteController
{
	
	/*public function getNoteCredit(Request $request, Response $response, array $args): Response
	{
		//$response->getBody()->write("***H0L4 Mund0***");
		$data_recibida = $request->getParsedBody();
		$prueba =new NameDAO();
		$resp = $prueba->testeo($data_recibida['id']);
		$resp_json = $response->withJson($resp);
		return $resp_json;
	}*/
	
	public function register_NC(Request $request, Response $response, array $args): Response
	{
		try{
			$data_recibida = $request->getParsedBody();
			$note_credit = new NoteCreditModel();
			
			$note_credit->setSale_id($data_recibida['header']['sale_id']);
			$note_credit->setResponseCode($data_recibida['header']['responseCode']);
			$note_credit->setInvoiceTypeCode($data_recibida['header']['invoiceTypeCode']);
			$note_credit->setSerieNumero($data_recibida['header']['serieNumero']);
			$note_credit->setIssueDate($data_recibida['header']['issueDate']);
			$note_credit->setIssueTime($data_recibida['header']['issueTime']);
			$note_credit->setDocumentCurrencyCode($data_recibida['header']['documentCurrencyCode']);
			$note_credit->setSupplierDocumentID($data_recibida['header']['supplierDocumentID']);
			$note_credit->setCustomerDocumentID($data_recibida['header']['customerDocumentID']);
			$note_credit->setCustomerID($data_recibida['header']['customerID']);
			$note_credit->setCustomerName($data_recibida['header']['customerName']);
			$note_credit->setTaxAmount($data_recibida['header']['taxAmount']);
			$note_credit->setTaxableAmount($data_recibida['header']['taxableAmount']);
			$note_credit->setNon_affected($data_recibida['header']['non_affected']);
			$note_credit->setExonerated($data_recibida['header']['exonerated']);
			$note_credit->setTaxSubtotal($data_recibida['header']['taxSubtotal']);
			$note_credit->setPayableAmount($data_recibida['header']['payableAmount']);
			$note_credit->setReferenceID($data_recibida['header']['referenceID']);
			$note_credit->setDocumentTypeCode($data_recibida['header']['DocumentTypeCode']);
			$note_credit->setDescription($data_recibida['header']['description']);
			$note_credit->setUser_create($data_recibida['header']['user_create']);
			$note_credit->setDate_create($data_recibida['header']['date_create']);
			$note_credit->setEstado(1);
			
			$datos_empresa_general = $this->conexionBDgeneral($data_recibida['information_additional']['supplierID']);
			
			$noteCredit_query= new NoteCreditDAO();
			$resp = $noteCredit_query->regist_NC_db($note_credit, $data_recibida['item'], $datos_empresa_general);//$note_credit_items);
			
			$note_credit->setSerieNumero($resp['0']);
			$note_credit->setId($resp['1']);
			
			if($resp['1']>0){
			
				$tramiento=$this->generarXML_NC($note_credit, $data_recibida['item'], $data_recibida['information_additional'], $datos_empresa_general);
				
				$note_credit->setFlg_response($tramiento['flg_response']);
				$note_credit->setError_code($tramiento['error_code']);
				$note_credit->setResponse_descrip($tramiento['response_descrip']);
				$note_credit->setDigest_value($tramiento['digest_value']);
				
				$noteCredit_query->update_data_XML_db($note_credit, $datos_empresa_general);
				
				$res_sendInovice = $this->enviarXML_NC($data_recibida, $note_credit->getSerieNumero(), $tramiento);
				
				$noteCredit_sendInvoice= new NoteCreditModelSendInvoice();
				
				if(strcmp(substr($note_credit->getReferenceID(),1,1),"B")==0){
					$tipo="AB";
				}else{
					if(strcmp(substr($note_credit->getReferenceID(),1,1),"F")==0){
						$tipo="AF";
					}else{
						$tipo="0";
					}
				}
				
				$noteCredit_sendInvoice->setNote_credit_id($note_credit->getId());
				$noteCredit_sendInvoice->setIssue_date($data_recibida['header']['issueDate']);
				$noteCredit_sendInvoice->setFile_name($res_sendInovice['file_name']);
				$noteCredit_sendInvoice->setType($tipo);
				$noteCredit_sendInvoice->setFlg_response($res_sendInovice['flg_response']);
				$noteCredit_sendInvoice->setError_code($res_sendInovice['error_code']);
				$noteCredit_sendInvoice->setResponse_descrip($res_sendInovice['response_descrip']);
				//$noteCredit_sendInvoice->setObservations();
				$noteCredit_sendInvoice->setStatus($res_sendInovice['status']);
				$noteCredit_sendInvoice->setUser_create($data_recibida['header']['user_create']);
				$noteCredit_sendInvoice->setDate_create($data_recibida['header']['date_create']);
				$noteCredit_sendInvoice->setEstado(1);
				
				$noteCredit_query->regist_send_invoice_NC($noteCredit_sendInvoice, $datos_empresa_general);
				
				$mensajeEnviar[0]=$note_credit->getSerieNumero();
				$mensajeEnviar[1]=$note_credit->getId();
				$mensajeEnviar[2]=$note_credit->getDigest_value();
				// $mensajeEnviar=$note_credit->getSerieNumero();
			}else{
				$mensajeEnviar[0]=0;
				$mensajeEnviar[1]=0;
				$mensajeEnviar[2]=0;
			}
		
		}catch(Exception $e){
			$mensajeEnviar[0]="error con WS";
			// $mensajeEnviar="error con WS";
		}
		
		$resp_json = $response->withJson($mensajeEnviar);
		return $resp_json;
		
		//$respuesta = $noteCredit_query->update_number_invoice();
		//$resp_json = $response->withJson($respuesta);
		//return $resp_json;
		
		
	}
	
	public function generarXML_NC (NoteCreditModel $note_credit, array $note_credit_items, array $information_additional, array $datos_empres):array//Request $request, Response $response, array $args):Response
	{
		
		$header= array(
			"nro_documento_modifica" => (string)($note_credit->getReferenceID()),
			"tipo_comprobante_modifica" => (string)("0".$note_credit->getDocumentTypeCode()),
			"descripcion_motivo" => (string)($note_credit->getDescription()),
			"codigo_ubigeo" => "",
            "direccion" => "",
            "direccion_departamento" => "",
            "direccion_provincia" => "",
            "direccion_distrito" => "",
            "direccion_codigopais" => "",
			"usuariosol" => $datos_empres['usuario_secundario'],
            "clavesol" => $datos_empres['clave_secundario'],
			'tipo_proceso' => $information_additional['beta'],
			
		
			"cod_tipo_motivo"=> (string)("0".$note_credit->getResponseCode()),
			"cod_tipo_documento"=> (string)("0".$note_credit->getInvoiceTypeCode()),
			"NRO_COMPROBANTE"=> (string)($note_credit->getSerieNumero()),
			"ruc"=> (string)($datos_empres['ruc']),
			"CLAVE_FIRMA"=> (string)($datos_empres['password_firma']),
			"fecha_comprobante"=> (string)($note_credit->getIssueDate()),
			//"issueTime"=> (string)($note_credit->getIssueTime()),
			"cod_moneda"=> (string)($note_credit->getDocumentCurrencyCode()),
			//"signatureID"=> (string)($note_credit->getSerieNumero()),
			"razon_social"=> (string)($datos_empres['razon_social']),
			//"URI"=> (string)("#".$note_credit->getSerieNumero()),
			"tipo_doc"=> (string)($note_credit->getSupplierDocumentID()),
			"cliente_tipodocumento"=> (string)($note_credit->getCustomerDocumentID()),
			"cliente_numerodocumento"=> (string)($note_credit->getCustomerID()),
			"cliente_nombre"=> (string)($note_credit->getCustomerName()),
			"total_igv"=> (string)($note_credit->getTaxAmount()),
			"total_gravadas"=> (string)($note_credit->getTaxableAmount()),
			"TOTAL_INAFECTA"=> (string)($note_credit->getNon_affected()),
			"TOTAL_EXONERADAS"=> (string)($note_credit->getExonerated()),
			//"taxSubtotal"=> (string)($note_credit->getTaxSubtotal()),
			"total"=> (string)($note_credit->getPayableAmount())
			);
				
		//$cont=1;
								
		for($contador=1; $contador < count($note_credit_items) + 1; $contador++){//foreach($items as $item_prod){
			
			if($note_credit_items[$contador]['TaxPercent']== 0){
		  
				  if($note_credit_items[$contador]['tax_method'] == 3){
					  
					  $CODIGO_IMPUESTO="9997";//codigoImp
					  $TIPO_IMPUESTO="EXO";//tipoImp
					  $TIPO_CODIGO_IMPUESTO="VAT";//typeCode
					  $CODIGO_CATEGORIA_IMPUESTO="E";//taxCategoryCode
					  $CODIGO_EXTENSION_IMPUESTO="20";//taxExemptionReasonCode
					  
				  }else{
					  
					  $CODIGO_IMPUESTO="9998";//codigoImp
					  $TIPO_IMPUESTO="INA";//tipoImp
					  $TIPO_CODIGO_IMPUESTO="FRE";//typeCode
					  $CODIGO_CATEGORIA_IMPUESTO="O";//taxCategoryCode
					  $CODIGO_EXTENSION_IMPUESTO="30";//taxExemptionReasonCode
					  
				  }
				  
			  }else{
				  $CODIGO_IMPUESTO="1000";//codigoImp
				  $TIPO_IMPUESTO="IGV";//tipoImp
				  $TIPO_CODIGO_IMPUESTO="VAT";//typeCode
				  $CODIGO_CATEGORIA_IMPUESTO="S";//taxCategoryCode
				  $CODIGO_EXTENSION_IMPUESTO="10";//taxExemptionReasonCode
			  }
									
				$item[$contador]= array(
					"txtUNIDAD_MEDIDA_DET" => "NIU",
					//"txtCOD_TIPO_OPERACION" => "10",
					'txtCODIGO_PROD_SUNAT' => '' ,
					//"txtPRECIO_TIPO_CODIGO" => "01",
					'CODIGO_IMPUESTO' => $CODIGO_IMPUESTO,
					'TIPO_IMPUESTO' => $TIPO_IMPUESTO,
					'TIPO_CODIGO_IMPUESTO' => $TIPO_CODIGO_IMPUESTO,
					'CODIGO_CATEGORIA_IMPUESTO' => $CODIGO_CATEGORIA_IMPUESTO,
					'CODIGO_EXTENSION_IMPUESTO' => $CODIGO_EXTENSION_IMPUESTO,
					
					"txtCANTIDAD_DET"=> (string)($note_credit_items[$contador]['Quantity']),
					//"txtIMPORTE_DET"=> (string)($note_credit_items[$contador]['LineExtensionAmount']),//con igv//segun guia sin igv
					"txtPRECIO_DET"=> (string)($note_credit_items[$contador]['PricingReference']),//con igv
					"txtPRECIO_TIPO_CODIGO"=> (string)($note_credit_items[$contador]['PriceTypeCode']),
					"txtIGV"=> (string)($note_credit_items[$contador]['TaxTotalTaxAmount']),
					"txtIMPORTE_DET"=> (string)($note_credit_items[$contador]['TaxSubtotalTaxableAmount']),
					"txtPRECIO_SIN_IGV_DET"=> (string)($note_credit_items[$contador]['PriceAmount']),//sin igv unitario
					//"txtIGV"=> (string)($note_credit_items[$contador]['TaxSubtotalTaxAmount']),
					"porcentaje_igv"=> (string)($note_credit_items[$contador]['TaxPercent']),
					//"tax_method"=>($note_credit_items[$contador]['tax_method']),
					"txtDESCRIPCION_DET"=> (string)($note_credit_items[$contador]['Description']),
					"txtCODIGO_DET"=> (string)($note_credit_items[$contador]['itemSellersID']),
					);
									
				//$cont = $cont + 1;
		}
								
		//var_dump($item);
								
		/*$reference = array(
			"nro_documento_modifica" => (string)($note_credit->getReferenceID()),
			"tipo_comprobante_modifica" => (string)("0".$note_credit->getDocumentTypeCode()),
			"descripcion_motivo" => (string)($note_credit->getDescription()),
		);*/
		
		
		$postData["header"] = $header;
		$postData["item"] = $item;
		//$postData["reference"] = $reference;
								
		/*if ($information_additional['beta'] == 0) {//$this->session->userdata('beta') == 0) {
			$urlDoc = "post/xml";
		} else {
			$urlDoc = "beta/post/xml";
		}*/
		$urlDoc = "notacredito.php";
								
		$context = stream_context_create(array(
			'http' => array(
			'method' => 'POST',
			'header' => "Authorization: application/json\r\n" .
			"Content-Type: application/json\r\n",
			'content' => json_encode($postData)
			)
		));
								
		$url = getenv('WSurl_fe');//'http://18.231.50.222/FEApi_pruebas/api/';//$this->config->item('aws_url');
		$response = file_get_contents($url . $urlDoc, false, $context);
								
		if ($response) {
			$res = json_decode($response, true);

			if($res["cod_sunat"] == "0"){
				  $NC_data["digest_value"] = $res["hash_cpe"];
				  $NC_data["response_descrip"] = $res["msj_sunat"];
				  $NC_data["flg_response"] =  "1";
			  }else{
				  $NC_data["digest_value"] =  "";
				  $NC_data["response_descrip"] = $res["mensaje"];
				  $NC_data["flg_response"] =  "0";
			  }
				
			  $NC_data["error_code"] =  $res["cod_sunat"];
			// $NC_data = array(
							// 'flg_response' => $res[0],
							// 'error_code' => $res[1],
							// 'response_descrip' => $res[2],
							// 'digest_value' => $res[4]
			// );

		//return $NC_data;

		} else {
			$NC_data = array(
			'flg_response' => "0",
			'error_code' => "0",
			'response_descrip' => "error al conectarse a WS-XML",
			'digest_value' => ""
			);

		//return $NC_data;
		}
		
		
		//*********************************************************************************************************
		//*********************************************************************************************************
		//$resultado = $noteCreditXML_query->consult_NC_header($dato[0]);// consulta header note credit
		//$resultado = $noteCreditXML_query->consult_NC_items($dato[0]);// consulta items note credit
		
		return $NC_data ;//"jejeje".$dato[0]);//$data_recibida = $request->getParsedBody();
		
		
	}
	
	public function enviarXML_NC($matriz, $serieCorrelativo, $dato_create_XML): array
	{
		/*
		if ($matriz['information_additional']['beta'] == 0){//$this->session->userdata('beta') == 0) {
			$urlDoc = "post/envio";
		} else {
			$urlDoc = "beta/post/envio";
		}

		$supplierID = $matriz['info_envio']['ruc'];//$this->session->userdata('ruc');
		$invoiceTypeCode = $matriz['header']['invoiceTypeCode'];//"01";
		$serieNumero = $serieCorrelativo;
*/
		$file_name = $matriz['info_envio']['ruc'] . "-" . $matriz['header']['invoiceTypeCode'] . "-" . $serieCorrelativo;
		
/*
		$usuSol = $matriz['info_envio']['usuSol'];//$this->session->userdata('user_sol');
		$passSol = $matriz['info_envio']['passSol'];//$this->session->userdata('pass_sol');

		$postData = array(
			'ruc' => $supplierID,
			'typeCode' => $invoiceTypeCode,
			'serieNumero' => $serieNumero,
			'usuSol' => $usuSol,
			'passSol' => $passSol
		);

		// Create the context for the request
		$context = stream_context_create(array(
			'http' => array(
				'method' => 'POST',
				'header' => "Authorization: application/json\r\n" .
					"Content-Type: application/json\r\n",
				'content' => json_encode($postData)
			)
		));

        // Send the request
		$url = getenv('WSurl_fe'); //$this->config->item('aws_url');
		$response = file_get_contents($url . $urlDoc, false, $context);
		*/
		//-------------Envio Sunat---------------//
		/*if ($response) {
			$res = json_decode($response, true);*/

			$tipo = "RF";

			// $datos = explode('-', $serieNumero, 2);
			// $serie = $datos[0];
			// $sNumero = $datos[1];

			/*if ($res[1] != 0) {
				$status = 3;
			} else {
				if ($res[0] == 1) {
					$status = 4;
				} else {
					$status = 1;
				}
			}*/
			
		if ($dato_create_XML["flg_response"] == 0) {
			$status = 3;
		  } else {
			if ($dato_create_XML["flg_response"] == 1) {
			  $status = 4;
			} else {
			  $status = 1;
			}
		  }
			
			$NC_data = array(
							'flg_response' => $dato_create_XML["flg_response"],//$res[0],
							'error_code' => $dato_create_XML["error_code"],//$res[1],
							'response_descrip' => $dato_create_XML["response_descrip"],//$res[3] . ": " . $res[2],
							'status' => $status,
							'file_name' => $file_name
			);
			
			
		/*} else {
			$NC_data = array(
			'flg_response' => "0",
			'error_code' => "0",
			'response_descrip' => "error al conectarse a AWS",
			'status' => "1",
			'file_name' => $file_name
			);

		//return $NC_data;
		}*/
		
		return $NC_data;
		
	}
	
	
	public function reenvio_NC(Request $request, Response $response, array $args): Response
	{
		
		$data_recibida = $request->getParsedBody();
		$note_credit = new NoteCreditModel();
		
		$datos_empresa_general = $this->conexionBDgeneral($data_recibida['information_additional']['supplierID']);
		
		$note_credit->setId($data_recibida['header']['id']);
		//$note_credit->setReferenceID($data_recibida['header']['referenceID']);
		
		$noteCredit_query= new NoteCreditDAO();
		/***************************TRJ156 - KENY PONTE - 20/02/2020********************* */
		$result=$noteCredit_query->consult_statusNC($note_credit->getId(), $datos_empresa_general);
		$resp= $noteCredit_query->consult_NC_header($note_credit->getId(), $datos_empresa_general);		
		/*if($result)
		{					
		//***************************TRJ156 - KENY PONTE - 20/02/2020*********************	
		$referenceID ="";			
			foreach($resp as $re){
				$referenceID=$re['referenceID'];
				$serieNumero=$re['serieNumero'];
				$issueDate=$re['issueDate'];
				$user_create=$re['user_create'];
				$date_create=$re['date_create'];
				$data_recibida['header']['invoiceTypeCode']="0".$re['invoiceTypeCode'];
			}			
			if($referenceID ==""){
				$mensajeEnviar[0]="No se re-envio";
				$mensajeEnviar[1]="error";
				$mensajeEnviar[2]="0";
			}else{				
				$statusReenvio = $noteCredit_query->valid_invoiceNC($note_credit->getId());
				$validStatus="";				
				foreach($statusReenvio as $status){
					$validStatus=$status['estado'];
				}				
				if($validStatus==""){					
					$note_credit->setReferenceID($referenceID);
					$note_credit->setSerieNumero($serieNumero);					
					$res_sendInovice = $this->enviarXML_NC($data_recibida, $note_credit->getSerieNumero());					
					$noteCredit_sendInvoice= new NoteCreditModelSendInvoice();							
					if(strcmp(substr($note_credit->getReferenceID(),1,1),"B")==0){
						$tipo="AB";
					}else{
						if(strcmp(substr($note_credit->getReferenceID(),1,1),"F")==0){
							$tipo="AF";
						}else{
							$tipo="0";
						}
					}							
					$noteCredit_sendInvoice->setNote_credit_id($note_credit->getId());
					$noteCredit_sendInvoice->setIssue_date($issueDate);
					$noteCredit_sendInvoice->setFile_name($res_sendInovice['file_name']);
					$noteCredit_sendInvoice->setType($tipo);
					$noteCredit_sendInvoice->setFlg_response($res_sendInovice['flg_response']);
					$noteCredit_sendInvoice->setError_code($res_sendInovice['error_code']);
					$noteCredit_sendInvoice->setResponse_descrip($res_sendInovice['response_descrip']);					
					$noteCredit_sendInvoice->setStatus($res_sendInovice['status']);
					$noteCredit_sendInvoice->setUser_create($user_create);
					$noteCredit_sendInvoice->setDate_create($date_create);
					$noteCredit_sendInvoice->setEstado(1);					
					$noteCredit_query->update_invoceNC($note_credit);
					$noteCredit_query->regist_send_invoice_NC($noteCredit_sendInvoice);
					
					$mensajeEnviar[0]="Se re-envio Con exito";
					$mensajeEnviar[1]="message";
					$mensajeEnviar[2]=$serieNumero;					
				}else{
					$mensajeEnviar[0]="Ya fue envio anteriormente con exito";
					$mensajeEnviar[1]="warning";
					$mensajeEnviar[2]=$serieNumero;
				}				
			}			
			$resp_json = $response->withJson($mensajeEnviar);
			return $resp_json;	
			//***************************TRJ156 - KENY PONTE - 20/02/2020********************* 					
		}else{*/			
			$note_creditHeader = new NoteCreditModel();	
			foreach($resp as $res){			
				$note_creditHeader->setSale_id((int)$data_recibida['header']['id']);
				$note_creditHeader->setResponseCode((int)$res['responseCode']);
				$note_creditHeader->setInvoiceTypeCode((int)$res['invoiceTypeCode']);
				$note_creditHeader->setSerieNumero((string)$res['serieNumero']);
				$note_creditHeader->setIssueDate((string)$res['issueDate']);
				$note_creditHeader->setIssueTime((string)$res['issueTime']);
				$note_creditHeader->setDocumentCurrencyCode((string)$res['documentCurrencyCode']);
				$note_creditHeader->setSupplierDocumentID((int)$res['supplierDocumentID']);
				$note_creditHeader->setCustomerDocumentID((int)$res['customerDocumentID']);
				$note_creditHeader->setCustomerID((string)$res['customerID']);
				$note_creditHeader->setCustomerName((string)$res['customerName']);
				$note_creditHeader->setTaxAmount((string)$res['taxAmount']);
				$note_creditHeader->setTaxableAmount((string)$res['taxableAmount']);
				$note_creditHeader->setNon_affected((string)$res['non_affected']);
				$note_creditHeader->setExonerated((string)$res['exonerated']);
				$note_creditHeader->setTaxSubtotal((string)$res['taxSubtotal']);
				$note_creditHeader->setPayableAmount((string)$res['payableAmount']);
				$note_creditHeader->setReferenceID((string)$res['referenceID']);
				$note_creditHeader->setDocumentTypeCode((int)$res['DocumentTypeCode']);
				$note_creditHeader->setDescription((string)$res['description']);
				$note_creditHeader->setUser_create((int)$res['user_create']);
				$note_creditHeader->setDate_create((string)$res['date_create']);
				$note_creditHeader->setEstado(1);
				$referenceID=$res['referenceID'];
				$serieNumero=$res['serieNumero'];
			}		
			$note_credit->setReferenceID($referenceID);
			$note_credit->setSerieNumero($serieNumero);
			$result_items=$noteCredit_query->obtieneItemsCN($note_creditHeader->getSale_id(), $datos_empresa_general);	
			$cont=1;
			$items[$cont]="";			
			foreach ($result_items as $result_item) {				
				$items[$cont]=array(
					"Quantity"=> $result_item['Quantity'],//"2",
					"LineExtensionAmount"=>$result_item['LineExtensionAmount'],//"20",//con igv
					"PricingReference"=> $result_item['PricingReference'],//"50",//con igv
					"PriceTypeCode"=> "0".$result_item['PriceTypeCode'],
					"TaxTotalTaxAmount"=>$result_item['TaxTotalTaxAmount'],//"3.6",
					"TaxSubtotalTaxableAmount"=> $result_item['TaxSubtotalTaxableAmount'],//"20",//total precio sin igv
					"PriceAmount"=>$result_item['PriceAmount'],//"40",//sin igv
					"TaxSubtotalTaxAmount"=> $result_item['TaxSubtotalTaxAmount'],//"3.6",
					"TaxPercent"=> $result_item['TaxPercent'],//"18",
					"tax_method"=> $result_item['tax_method'],//"18",
					"Description"=> $result_item['Description'],//"Producto Prueba 01",
					"itemSellersID"=> $result_item['itemSellersID'],//"123"

				);
				$cont++;			
			}						
			$data_recibida['item']=$items;					
			$tramiento=$this->generarXML_NC($note_creditHeader, $data_recibida['item'], $data_recibida['information_additional'], $datos_empresa_general);
			if($tramiento){

				//$noteCredit_query->update_NC($tramiento, $note_credit->getId());
			   $note_credit->setFlg_response($tramiento['flg_response']);
				$note_credit->setError_code($tramiento['error_code']);
				$note_credit->setResponse_descrip($tramiento['response_descrip']);
				$note_credit->setDigest_value($tramiento['digest_value']);				
				$noteCredit_query->update_data_XML_db($note_credit, $datos_empresa_general);
				//return $response->withJson($data_recibida);
				$data_recibida['header']['invoiceTypeCode']="0".$note_creditHeader->getInvoiceTypeCode();				
				$res_sendInovice = $this->enviarXML_NC($data_recibida, $note_credit->getSerieNumero(), $tramiento);	
				if($res_sendInovice){

						
					$noteCredit_sendInvoice= new NoteCreditModelSendInvoice();			
					if(strcmp(substr($note_credit->getReferenceID(),0,1),"B")==0){
						$tipo="AB";
					}else{
						if(strcmp(substr($note_credit->getReferenceID(),0,1),"F")==0){
							$tipo="AF";
						}else{
							$tipo="0";
						}
					}				
					$noteCredit_sendInvoice->setNote_credit_id($note_credit->getId());			
					$noteCredit_sendInvoice->setIssue_date($note_creditHeader->getIssueDate());//$res_sendInovice['Issue_date']);
					$noteCredit_sendInvoice->setFile_name($res_sendInovice['file_name']);
					$noteCredit_sendInvoice->setType($tipo);
					$noteCredit_sendInvoice->setFlg_response($res_sendInovice['flg_response']);
					$noteCredit_sendInvoice->setError_code($res_sendInovice['error_code']);
					$noteCredit_sendInvoice->setResponse_descrip($res_sendInovice['response_descrip']);
					//$noteCredit_sendInvoice->setObservations();
					$noteCredit_sendInvoice->setStatus($res_sendInovice['status']);				
					$noteCredit_sendInvoice->setUser_create($data_recibida['header']['user_id']);				
					$noteCredit_sendInvoice->setDate_create(date("Y-m-d H:i:s") );
					$noteCredit_sendInvoice->setEstado(1);				
					
					$noteCredit_query->update_invoceNC($note_credit, $datos_empresa_general);
					
					$noteCredit_query->regist_send_invoice_NC($noteCredit_sendInvoice, $datos_empresa_general);				
					$mensajeEnviar[0]=$note_credit->getSerieNumero();
					$mensajeEnviar[1]=$note_credit->getId();
					$mensajeEnviar[2]=$note_credit->getDigest_value();
					// $mensajeEnviar=$note_credit->getSerieNumero();
					$mensajeEnviar[0]="Se re-envio Con exito";
					$mensajeEnviar[1]="message";
					$mensajeEnviar[2]=$serieNumero;
					return $response->withJson($mensajeEnviar);	
				}
				else{
					$mensajeEnviar[0]="No se re-envio";
				$mensajeEnviar[1]="error";
				$mensajeEnviar[2]="0";
				return $response->withJson($mensajeEnviar);	
				}		
			}
			else{
				$mensajeEnviar[0]="No se re-envio";
				$mensajeEnviar[1]="error";
				$mensajeEnviar[2]="0";
				return $response->withJson($mensajeEnviar);	
			}					
		//}
		/***************************TRJ156 - KENY PONTE - 20/02/2020********************* */		
	}
	
	public function conexionBDgeneral($ruc){
	
		$postData['ruc']=$ruc;
		
		$context = stream_context_create(array(
				'http' => array(
				'method' => 'POST',
				'header' => "Authorization: application/json\r\n" .
				"Content-Type: application/json\r\n",
				'content' => json_encode($postData)
				)
			));
									
		$url = getenv('WSurl_general');
		$urlDoc="v1/Empresa/datos";
		$response = file_get_contents($url . $urlDoc, false, $context);
		$res = json_decode($response, true);
		
		$datosEmp['ruc']=$res['ruc'];
		$datosEmp['razon_social']=$res['razon_social'];
		$datosEmp['usuario_sol']=$res['usuario_sol'];
		$datosEmp['usuario_secundario']=$res['usuario_secundario'];
		$datosEmp['clave_secundario']=$res['clave_secundario'];
		$datosEmp['password_firma']=$res['password_firma'];
		$datosEmp['host_BD']=$res['host_BD'];
		
		$datosEmp['BD_sistema']=$res['BD_sistema'];
		$datosEmp['usuario_BD']=$res['usuario_BD'];
		$datosEmp['password_BD']=$res['password_BD'];
		
		
		return $datosEmp;
	}
	
}
