<?php

namespace App\DAO\MySQL\CodeBD;
use App\Models\MySQL\CodeyGenerateCustomer\CustomerModel;

class CustomerDAO extends Conexao
{
	
	public function __construct()
	{
		parent::__construct();
	}
	
	public function valid_Customer($dni, $ruc, array $datos_emp): array
	{
		
		try{
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
		
			$statement = $conexion->prepare('CALL `validate_customer`(
				:numIdentif,
				:rucEmp
			);');
			
			$statement->execute([
				'numIdentif' => $dni,
				'rucEmp'=> $ruc
			]);
			
			$row = $statement->fetchAll(\PDO::FETCH_ASSOC);
			$statement->closeCursor();
			return $row;
			
		}catch(PDOException $e){
			$row[0] =0;
			
			return $row;
		}
		
	}
	
	public function insert_customer(CustomerModel $customer, $ruc, array $datos_emp): array
	{
		try{
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
			$statement = $conexion->prepare('CALL `register_customer`(
				@result_id,
				:nameP,
				:cf1P,
				:cf2P,
				:phoneP,
				:emailP,
				:direccionP,
				:customers_type_idP,
				:estadoP,
				:person_typeP,
				:document_type_idP,
				:rucEmp
			);');
			
			$statement->execute([
				'nameP' => $customer->getName(),
				'cf1P' => $customer->getCf1(),
				'cf2P' => $customer->getCf2(),
				'phoneP' => $customer->getPhone(),
				'emailP' => $customer->getEmail(),
				'direccionP' => $customer->getDireccion(),
				'customers_type_idP' => $customer->getCustomers_type_id(),
				'estadoP' => $customer->getEstado(),
				'person_typeP' => $customer->getPerson_type(),
				'document_type_idP' => $customer->getDocument_type_id(),
				'rucEmp' => $ruc
			]);
			
			$row = $conexion->query("SELECT @result_id AS result_id")->fetch(\PDO::FETCH_ASSOC);
			$statement->closeCursor();
			$respuestaSol[0]=$row['result_id'];
			return $respuestaSol;
			
		}catch(PDOException $e){
			$respuestaSol[0] =0;
			
			return $respuestaSol;
		}
	}
	
	public function valid_tipo_cliente($id_tipo, array $datos_emp): array
	{
		
		try{
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
		
			$statement = $conexion->prepare('CALL `valid_tipo_cliente`(
				:id_tipo
			);');
			
			$statement->execute([
				'id_tipo' => $id_tipo
			]);
			
			$row = $statement->fetchAll(\PDO::FETCH_ASSOC);
			$statement->closeCursor();
			return $row;
			
		}catch(PDOException $e){
			$row[0] =0;
			
			return $row;
		}
		
	}
	
	public function valid_tipo_documento($id_tipo, array $datos_emp): array
	{
		
		try{
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
		
			$statement = $conexion->prepare('CALL `valid_tipo_documento`(
				:id_tipo
			);');
			
			$statement->execute([
				'id_tipo' => $id_tipo
			]);
			
			$row = $statement->fetchAll(\PDO::FETCH_ASSOC);
			$statement->closeCursor();
			return $row;
			
		}catch(PDOException $e){
			$row[0] =0;
			
			return $row;
		}
		
	}
	
}