<?php 

namespace App\Models\MySQL\CodeyGenerateNoteCredit;

final class NoteCreditItemsModel{
	
	/**
	* @var int
	*/
	private $id;
	
	/**
	* @var int
	*/
	private $credit_note_id;
	
	/**
	* @var int
	*/
	private $Quantity;
	
	/**
	* @var int
	*/
	private $LineExtensionAmount;
	
	/**
	* @var int
	*/
	private $PricingReference;
	
	/**
	* @var int
	*/
	private $PriceTypeCode;
	
	/**
	* @var string
	*/
	private $TaxTotalTaxAmount;
	
	/**
	* @var int
	*/
	private $TaxSubtotalTaxableAmount;
	
	/**
	* @var int
	*/
	private $PriceAmount;
	
	/**
	* @var string
	*/
	private $TaxSubtotalTaxAmount;
	
	/**
	* @var int
	*/
	private $TaxPercent;
	
	/**
	* @var int
	*/
	private $tax_method;
	
	/**
	* @var string
	*/
	private $Description;
	
	/**
	* @var int
	*/
	private $itemSellersID;
	
	/**
	* @var int
	*/
	private $user_create;
	
	/**
	* @var string
	*/
	private $date_create;
	
	/**
	* @var int
	*/
	private $user_upgrade;
	
	/**
	* @var string
	*/
	private $date_upgrade;
	
	/**
	* @var int
	*/
	private $estado;
	
	//**************************************************************
	
	/**
	* @return int
	*/
	public function getId(): int
	{
		return $this->id;
	}
	
	/**
	* @return int
	*/
	public function getCredit_note_id(): int
	{
		return $this->credit_note_id;
	}
	
	/**
	* @return int
	*/
	public function getQuantity(): int
	{
		return $this->Quantity;
	}
	
	/**
	* @return int
	*/
	public function getLineExtensionAmount(): int
	{
		return $this->LineExtensionAmount;
	}
	
	/**
	* @return int
	*/
	public function getPricingReference(): int
	{
		return $this->PricingReference;
	}
	
	/**
	* @return int
	*/
	public function getPriceTypeCode(): int
	{
		return $this->PriceTypeCode;
	}
	
	/**
	* @return int
	*/
	public function getTaxTotalTaxAmount(): string
	{
		return $this->TaxTotalTaxAmount;
	}
	
	/**
	* @return int
	*/
	public function getTaxSubtotalTaxableAmount(): int
	{
		return $this->TaxSubtotalTaxableAmount;
	}
	
	/**
	* @return int
	*/
	public function getPriceAmount(): int
	{
		return $this->PriceAmount;
	}
	
	/**
	* @return int
	*/
	public function getTaxSubtotalTaxAmount(): string
	{
		return $this->TaxSubtotalTaxAmount;
	}
	
	/**
	* @return int
	*/
	public function getTaxPercent(): int
	{
		return $this->TaxPercent;
	}
	
	/**
	* @return int
	*/
	public function getTax_method(): int
	{
		return $this->tax_method;
	}
	
	/**
	* @return int
	*/
	public function getDescription(): string
	{
		return $this->Description;
	}
	
	/**
	* @return int
	*/
	public function getItemSellersID(): string
	{
		return $this->itemSellersID;
	}
	
	/**
	* @return int
	*/
	public function getUser_create(): int
	{
		return $this->user_create;
	}
	
	/**
	* @return string
	*/
	public function getDate_create(): string
	{
		return $this->date_create;
	}
	
	/**
	* @return int
	*/
	public function getUser_upgrade(): int
	{
		return $this->user_upgrade;
	}
	
	/**
	* @return string
	*/
	public function getDate_upgrade(): string
	{
		return $this->date_upgrade;
	}
	
	/**
	* @return int
	*/
	public function getEstado(): int
	{
		return $this->estado;
	}
	
	//********************************************************************
		
	/**
	* @param int $credit_note_id
	* @return NoteCreditItemsModelModel
	*/
	public function setCredit_note_id(int $credit_note_id)//: NoteCreditItemsModelModel
	{
		$this->credit_note_id = $credit_note_id;
	}
	
	/**
	* @param int $Quantity
	* @return NoteCreditItemsModelModel
	*/
	public function setQuantity(int $Quantity)//: NoteCreditItemsModelModel
	{
		$this->Quantity = $Quantity;
	}
	
	/**
	* @param int $LineExtensionAmount
	* @return NoteCreditItemsModelModel
	*/
	public function setLineExtensionAmount(int $LineExtensionAmount)//: NoteCreditItemsModelModel
	{
		$this->LineExtensionAmount = $LineExtensionAmount;
	}
	
	/**
	* @param int $PricingReference
	* @return NoteCreditItemsModelModel
	*/
	public function setPricingReference(int $PricingReference)//: NoteCreditItemsModelModel
	{
		$this->PricingReference = $PricingReference;
	}
	
	/**
	* @param int $PriceTypeCode
	* @return NoteCreditItemsModelModel
	*/
	public function setPriceTypeCode(int $PriceTypeCode)//: NoteCreditItemsModelModel
	{
		$this->PriceTypeCode = $PriceTypeCode;
	}
	
	/**
	* @param string $TaxTotalTaxAmount
	* @return NoteCreditItemsModelModel
	*/
	public function setTaxTotalTaxAmount(string $TaxTotalTaxAmount)//: NoteCreditItemsModelModel
	{
		$this->TaxTotalTaxAmount = $TaxTotalTaxAmount;
	}
	
	/**
	* @param int $TaxSubtotalTaxableAmount
	* @return NoteCreditItemsModelModel
	*/
	public function setTaxSubtotalTaxableAmount(int $TaxSubtotalTaxableAmount)//: NoteCreditItemsModelModel
	{
		$this->TaxSubtotalTaxableAmount = $TaxSubtotalTaxableAmount;
	}
	
	/**
	* @param int $PriceAmount
	* @return NoteCreditItemsModelModel
	*/
	public function setPriceAmount(int $PriceAmount)//: NoteCreditItemsModelModel
	{
		$this->PriceAmount = $PriceAmount;
	}
	
	/**
	* @param string $TaxSubtotalTaxAmount
	* @return NoteCreditItemsModelModel
	*/
	public function setTaxSubtotalTaxAmount(string $TaxSubtotalTaxAmount)//: NoteCreditItemsModelModel
	{
		$this->TaxSubtotalTaxAmount = $TaxSubtotalTaxAmount;
	}
	
	/**
	* @param int $TaxPercent
	* @return NoteCreditItemsModelModel
	*/
	public function setTaxPercent(int $TaxPercent)//: NoteCreditItemsModelModel
	{
		$this->TaxPercent = $TaxPercent;
	}
	
	/**
	* @param int $tax_method
	* @return NoteCreditItemsModelModel
	*/
	public function setTax_method(int $tax_method)//: NoteCreditItemsModelModel
	{
		$this->tax_method = $tax_method;
	}
	
	/**
	* @param string $Description
	* @return NoteCreditItemsModelModel
	*/
	public function setDescription(string $Description)//: NoteCreditItemsModelModel
	{
		$this->Description = $Description;
	}
	
	/**
	* @param int $itemSellersID
	* @return NoteCreditItemsModelModel
	*/
	public function setItemSellersID(string $itemSellersID)//: NoteCreditItemsModelModel
	{
		$this->itemSellersID = $itemSellersID;
	}
	
	/**
	* @param string $user_create
	* @return NoteCreditModel
	*/
	public function setUser_create(int $user_create)//: NoteCreditModel
	{
		$this->user_create = $user_create;
	}
	
	/**
	* @param string $date_create
	* @return NoteCreditModel
	*/
	public function setDate_create(string $date_create)//: NoteCreditModel
	{
		$this->date_create = $date_create;
	}
	
	/**
	* @param string $user_upgrade
	* @return NoteCreditModel
	*/
	public function setUser_upgrade(int $user_upgrade)//: NoteCreditModel
	{
		$this->user_upgrade = $user_upgrade;
	}
	
	/**
	* @param string $date_upgrade
	* @return NoteCreditModel
	*/
	public function setDate_upgrade(string $date_upgrade)//: NoteCreditModel
	{
		$this->date_upgrade = $date_upgrade;
	}
	
	/**
	* @param string $estado
	* @return NoteCreditModel
	*/
	public function setEstado(int $estado)//: NoteCreditModel
	{
		$this->estado = $estado;
	}
	
}