<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Document_type extends MY_Controller
{

    function __construct() {
        parent::__construct();

 
        if (!$this->loggedIn) {
            redirect('login');
        }

        $this->load->library('form_validation');
        // $this->load->model('document_type_model');
    }

    function index() {

       
   
        $this->data['error'] = validation_errors() ? validation_errors() : $this->session->flashdata('error');
        $this->data['page_title'] = lang('documents');
        $bc = array(array('link' => '#', 'page' => lang('documents')));
        $meta = array(
            'page_title' => lang('Tipos de documento'),
            'bc' => $bc);
        $this->page_construct('documents/index', $this->data, $meta);

    }

    public function get_documents(){
        
        $urlDoc = "doc";
        $context = stream_context_create(array(
            'http' => array(
            'method' => 'GET',
            'header' => "Authorization: application/json\r\n" .
            "Content-Type: application/json\r\n",
            )
        ));
        $url = $this->config->item('api_general');
        $columnas = array(
            0 => 'id',
            1 => 'code',
            2 => 'description',
            3 => 'edit',
            4 => 'show',
            5 => 'delete'
        );

        $data = $_GET;
       
        $filtro = $_GET["search"]['value'];
        $orderby = $columnas[$data['order'][0]['column']];
        $orderdir = $_GET['order'][0]['dir'];
        $start = $_GET['start'];
        $length = $_GET['length'];
        $draw = $_GET["draw"];

        $rows = array();
        $temporal = array();

        if ($filtro != "") {
            $values = "?search=" . $filtro . "&orderby=" . $orderby . "&orderdir=" . $orderdir . "&start=" . $start . "&length=" . $length;
            $urlDoc = $urlDoc . $values;
        } else {
            $values = "?orderby=" . $orderby . "&orderdir=" . $orderdir . "&start=" . $start . "&length=" . $length;
            $urlDoc = $urlDoc . $values;                  
        }
        
        $response = file_get_contents($url . $urlDoc, false, $context);
        $documents = json_decode($response, true);

        $contador_total = $documents['data']['total'];
        $rows['draw'] = $draw;
        $rows['recordsFiltered'] = $contador_total;

        if($documents['result']=='ok'){
            foreach ($documents['data']['list'] as $item) {
                $id = $item['id'];
                $code = $item['code'];
                $description = $item['description'];

                $edit = '<span class="btn"><a href="' . site_url('documents/edit/' . $id) . '" title="' . lang("edit_description") . '"><i class="fa fa-edit"></i></a></span>';
                $show = '<span class="btn"><a href="' . site_url('documents/show/' . $id) . '" title="' . lang("show") . '"><i class="fa fa-eye"></i></a></span>';
                $delete = '<span class="btn"><a href="' . site_url('documents/delete/' . $id) . '" onClick="return confirm(&#39;' . lang("delete_description") . '&#39;)" title="' . lang("delete") . '"><i class="fa fa-trash-o"></i></a></span>';
                $option="<a href='".site_url('documents/show/' . $id)."' title='" . lang('show_series') . "'    class='btn-edit tip btn btn-warning btn-xs'><i class='fa fa-eye'></i></a> ";

                $datos = (array('id' => $id, 'code' => $code, 'description' => $description, 'edit' => $edit, 'show' => $show, 'delete' => $delete, 'option' => $option));
                array_push($temporal,$datos);
            }
        }else{
            $id = '';
            $code = '';
            $description = '';

            $edit = '<span class="btn"><a href="' . site_url('documents/edit/' . $id) . '" title="' . lang("edit_description") . '"><i class="fa fa-edit"></i></a></span>';
            $show = '<span class="btn"><a href="' . site_url('documents/show/' . $id) . '" title="' . lang("show") . '"><i class="fa fa-eye"></i></a></span>';
            $delete = '<span class="btn"><a href="' . site_url('documents/delete/' . $id) . '" onClick="return confirm(&#39;' . lang("delete_description") . '&#39;)" title="' . lang("delete") . '"><i class="fa fa-trash-o"></i></a></span>';
            $option="<a href='".site_url('documents/show/' . $id)."' title='" . lang('show_series') . "'    class='btn-edit tip btn btn-warning btn-xs'><i class='fa fa-eye'></i></a> ";

            $datos = (array('id' => $id, 'code' => $code, 'description' => $description, 'edit' => $edit, 'show' => $show, 'delete' => $delete, 'option' => $option));
            array_push($temporal,$datos);
        }
        $rows['data'] = $temporal;

        echo json_encode($rows);
    }

    public function documents_all(){
        
        $urlDoc = "doc";
        $context = stream_context_create(array(
            'http' => array(
            'method' => 'GET',
            'header' => "Authorization: application/json\r\n" .
            "Content-Type: application/json\r\n",
            )
        ));
        $url = $this->config->item('api_general');
        $rows = array();
        $temporal = array();
        $response = file_get_contents($url . $urlDoc, false, $context);
        $documents = json_decode($response, true);
        $rows['data'] = $documents;

        echo json_encode($rows);
    }

    public function show($id = null){
        
        $urlSerie = "serie";
        $context = stream_context_create(array(
            'http' => array(
            'method' => 'GET',
            'header' => "Authorization: application/json\r\n" .
            "Content-Type: application/json\r\n",
            )
        ));
        $url = $this->config->item('api_general');

        $data = $_GET;
       
        $filtro = $_GET["search"]['value'];
        $orderby = 'serie';
        $orderdir = $_GET['order'][0]['dir'];
        $start = $_GET['start'];
        $length = $_GET['length'];
        $draw = $_GET["draw"];

        $rows = array();
        $temporal = array();

        if ($filtro != "") {
            $values = "?search=" . $filtro . "&orderby=" . $orderby . "&orderdir=" . $orderdir . "&start=" . $start . "&length=" . $length;
            $urlSerie = $urlSerie . $values;
        } else {
            $values = "?orderby=" . $orderby . "&orderdir=" . $orderdir . "&start=" . $start . "&length=" . $length;
            $urlSerie = $urlSerie . $values;                  
        }
        
        $response = file_get_contents($url . $urlSerie, false, $context);
        $documents = json_decode($response, true);

        $contador_total = count($documents);
        $contador_filtrado = count($documents);
        $rows['draw'] = $draw;

        $rows['recordsTotal'] = $contador_total;
        $rows['recordsFiltered'] = $contador_filtrado;
        foreach ($documents['data'] as $item) {
            $id = $item['id'];
            $code = $item['code'];
            $description = $item['description'];

            $edit = '<span class="btn"><a href="' . site_url('documents/edit/' . $id) . '" title="' . lang("edit_description") . '"><i class="fa fa-edit"></i></a></span>';
            $show = '<span class="btn"><a href="' . site_url('series/' . $id) . '" title="' . lang("show_series") . '"><i class="fa fa-eye"></i></a></span>';
            $delete = '<span class="btn"><a href="' . site_url('documents/delete/' . $id) . '" onClick="return confirm(&#39;' . lang("delete_description") . '&#39;)" title="' . lang("delete") . '"><i class="fa fa-trash-o"></i></a></span>';

            $datos = (array('id' => $id, 'code' => $code, 'description' => $description, 'edit' => $edit, 'show' => $show, 'delete' => $delete));
            array_push($temporal,$datos);
        }

        $rows['data'] = $temporal;

        echo json_encode($rows);
    }
}