<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box" style="border-top: 2.5px solid #004785;">
                <!--div class="box-header">
                    <h3 class="box-title"><?= lang('update_info'); ?></h3>
                </div-->
                <div class="box-body">
                    <div class="col-lg-12">
                        <?php
                        $attrib = array('class' => 'validation', 'role' => 'form');

                        echo form_open("warehouses/edit/".$warehouse->id, $attrib); ?>
                        <div class="row">
                            <div class="col-lg-2 col-md-3">
                                <div class="form-group">
                                    <?= lang("warehouse_code", "warehouse_code"); ?>
                                    <?php echo form_input('warehouse_code', set_value('warehouse_code', (isset($form_data['warehouse_code']) ? $form_data['warehouse_code'] : $warehouse->code)), 'class="form-control" id="warehouse_code" required="required" maxlength="10"'); ?>
                                </div>
                            </div>
                            <div class="col-lg-10 col-md-9">
                                <div class="form-group">
                                    <?= lang("warehouse_name", "warehouse_name"); ?>
                                    <?php echo form_input('warehouse_name', set_value('warehouse_name', (isset($form_data['warehouse_name']) ? $form_data['warehouse_name'] : $warehouse->warehouse)), 'class="form-control" id="warehouse_name" required="required" maxlength="80"'); ?>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <?= lang("warehouse_address", "warehouse_address"); ?>
                                    <?php echo form_input('warehouse_address', set_value('warehouse_address', (isset($form_data['warehouse_address']) ? $form_data['warehouse_address'] : $warehouse->address)), 'class="form-control" id="warehouse_address" required="required" maxlength="100"'); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="warehouse_department"> <?= lang("warehouse_department", "warehouse_department"); ?></label>
                                    <select class="form-control form-control-sm" name="warehouse_department" id="warehouse_department">
                                    <option value="0"><?=lang("select")?></option>
                                       <?php
                                        foreach($departamentList as $departament) { ?>
                                            <option value="<?=$departament['id']?>" <?=(isset($warehouse->codDepa) && $warehouse->codDepa == $departament['id'])?'selected':((set_value('departament')==$departament['id'])?"selected":"")?>><?=$departament['description']?></option>
                                        <?php }?>
                                    </select>
                                </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                <label for="warehouse_province"><?= lang("warehouse_province", "warehouse_province"); ?></label>
                                    <select class="form-control" name="warehouse_province" id="warehouse_province">
                                        <option><?=lang("select")?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="warehouse_district"><?= lang("warehouse_district", "warehouse_district"); ?></label>
                                    <select class="form-control" name="warehouse_district" id="warehouse_district" required="required">
                                        <option value=""><?=lang("select")?></option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <fieldset class="warehouse-border">
                                    <legend class="warehouse-border"><?= lang("warehouse_external_guide", "warehouse_external_guide"); ?></legend>
                                    <div class="col-md-1">
                                        <div class="form-group">
                                            <?= lang("warehouse_external_guide_serie", "warehouse_external_guide_serie"); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?php echo form_input('warehouse_external_guide_serie', set_value('warehouse_external_guide_serie', (isset($form_data['warehouse_external_guide_serie']) ? $form_data['warehouse_external_guide_serie'] : $warehouse->external_guide_serie)), 'class="form-control input-alpha" id="warehouse_external_guide_serie" required="required" maxlength="4"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <?= lang("warehouse_external_guide_number", "warehouse_external_guide_number"); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?php echo form_input('warehouse_external_guide_number', set_value('warehouse_external_guide_number', (isset($form_data['warehouse_external_guide_number']) ? $form_data['warehouse_external_guide_number'] : $warehouse->external_guide_number)), 'class="form-control input-number" id="warehouse_external_guide_number" required="required" maxlength="8"'); ?>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                            <div class="col-md-6">
                                <fieldset class="warehouse-border">
                                    <legend class="warehouse-border"><?= lang("warehouse_internal_guide", "warehouse_internal_guide"); ?></legend>
                                    <div class="col-md-1">
                                        <div class="form-group">
                                            <?= lang("warehouse_internal_guide_serie", "warehouse_internal_guide_serie"); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?php echo form_input('warehouse_internal_guide_serie', set_value('warehouse_internal_guide_serie', (isset($form_data['warehouse_internal_guide_serie']) ? $form_data['warehouse_internal_guide_serie'] : $warehouse->internal_guide_serie)), 'class="form-control input-alpha" id="warehouse_internal_guide_serie" required="required" maxlength="4"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-2">
                                        <div class="form-group">
                                            <?= lang("warehouse_internal_guide_number", "warehouse_internal_guide_number"); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?php echo form_input('warehouse_internal_guide_number', set_value('warehouse_internal_guide_number', (isset($form_data['warehouse_internal_guide_number']) ? $form_data['warehouse_internal_guide_number'] : $warehouse->internal_guide_number)), 'class="form-control input-number" id="warehouse_internal_guide_number" required="required" maxlength="8"'); ?>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                            <div class="col-md-12">                                
                                <div class="form-group">

                                    <input type="hidden" name="warehouse_department_value" id="warehouse_department_value" value="<?php echo $ubigeo->departamento; ?>">
                                    <input type="hidden" name="warehouse_province_value" id="warehouse_province_value" value="<?php echo $ubigeo->provincia; ?>">
                                    <input type="hidden" name="warehouse_district_value" id="warehouse_district_value" value="<?php echo $ubigeo->distrito; ?>">

                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="col-md-12 text-right">
                                        <?php echo form_submit('add_customer', $this->lang->line("accept"), 'class="btn btn-primary" id="btn-accept"'); ?>
                                        <a id="btn-cancel" class="btn btn-danger"><?= lang("cancel") ?></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php echo form_close(); ?>

                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="<?= $assets ?>dist/js/pages/Warehouses.js" type="text/javascript"></script>

<script src="<?= $assets ?>plugins/input-mask/jquery.inputmask.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/input-mask/jquery.inputmask.date.extensions.js" type="text/javascript"></script>
<?php if(isset($warehouse->location) && !empty($warehouse->location)){ ?>
 <script>
   $(document).ready(function() {
    $('#warehouse_department').trigger('change');
    $('#warehouse_province > option[value="<?=$warehouse->codProv?>"]').attr('selected', 'selected');
    $('#warehouse_province').trigger('change');
    $('#warehouse_district > option[value="<?=$warehouse->location?>"]').attr('selected', 'selected');
   
});
 </script>
<?php }?>
<script>
$(document).ready(function () {
    $('#warehouse_code').focus();
    $('#btn-cancel').click(function (e) {
        if (confirm("¿Está seguro que desea cancelar?")) {
            window.location.href = base_url + "brands"
        }
    });
});
</script>