DELIMITER $$

DROP PROCEDURE IF EXISTS `apiadministrador`.`SP_ADMIN_LISTAR_EMPRESAS_POR_ID`$$

CREATE  PROCEDURE SP_ADMIN_LISTAR_EMPRESAS_POR_ID(
      IN pint_id_empresa INT
    )
BEGIN
    select 	
    per.id_persona, 									per.id_tip_doc, 									per.num_documento, 
	per.tip_persona, 									per.nombres, 										per.ape_paterno,
	per.ape_materno, 									per.ruc, 
    perc.id_persona as id_pers_contacto, 				perc.id_tip_doc as id_tip_doc_contacto, 			perc.num_documento as num_documento_contacto, 
	perc.tip_persona as tip_persona_contacto, 			perc.nombres as nombres_contacto, 					perc.ape_paterno as ape_paterno_contacto, 
	perc.ape_materno as ape_materno_contacto, 			perc.ruc as ruc_contacto, 
	cont.id_contactos, 									cont.email1, 										cont.email2, 
	cont.movil1, 										cont.movil2, 										cont.movil3, 		 
	emp.id_empresa, 									emp.direccion, 										emp.ubigeo, 
	emp.sub_dominio, 									emp.db_host, 										emp.db_name, 
	emp.db_usuario, 									emp.db_contrasena, 									emp.fec_afiliacion, 
	emp.fec_suspension, 								emp.fec_cancelacion, 								emp.id_vendedor, 
	emp.flg_reconexion  
	from 
	empresas emp inner JOIN personas per 
	on emp.id_persona= per.id_persona
	inner JOIN contactos cont 
	on emp.id_empresa=cont.id_empresa
	inner join personas perc 
	on cont.id_persona=perc.id_persona
	where emp.id_empresa=pint_id_empresa;

	
    END$$

DELIMITER ;