<?php
namespace App\Repositories\Interfaces;

use App\Models\Model;
use App\DTOs\Models\ModelCreateDto;
use App\DTOs\Models\ModelUpdateDto;

interface IModelRepository
{
    public function paginate(array $request);
    public function find(int $id): ?Model;
    public function findModelsByBrand(int $brand_id);
    public function store(ModelCreateDto $store): Model;
    public function update(ModelUpdateDto $store): void;
    public function destroy(int $id): void;
}
