<?php
namespace App\Repositories\Interfaces;

use App\DTOs\PriceProduct\PriceProductCreateDto;
use App\Models\Product;
use App\DTOs\Products\ProductCreateDto;
use App\DTOs\Products\ProductUpdateDto;
use App\Models\PrecioProductoPorTipoCliente;

interface IProductRepository
{
    public function paginate(array $request);
    public function find(int $id): ?Product;
    public function store(ProductCreateDto $store): Product;
    public function update(ProductUpdateDto $store): void;
    public function destroy(int $id): void;
    public function priceProductByCustomersTypeList(array $request, string $ruc);
    public function priceProductByCustomersTypeStore(PriceProductCreateDto $storePrice):PrecioProductoPorTipoCliente;
    public function priceProductByCustomersTypeFind(int $product_id,int $customer_type_id,string $ruc_business);
}
