<?php
namespace App\Providers;

use App\Repositories\WarehouseRepository;
use App\Repositories\UnitMeasureRepository;
use App\Repositories\BrandRepository;
use App\Repositories\ModelRepository;
use App\Repositories\TypeMovementRepository;
use App\Repositories\WarehouseGuideRepository;
use App\Repositories\WarehouseGuideDetailRepository;
use App\Repositories\ProductRepository;
use App\Services\WarehouseGuideService;
use Illuminate\Support\ServiceProvider;
use App\Repositories\Interfaces\IWarehouseRepository;
use App\Repositories\Interfaces\IUnitMeasureRepository;
use App\Repositories\Interfaces\IBrandRepository;
use App\Repositories\Interfaces\IModelRepository;
use App\Repositories\Interfaces\ITypeMovementRepository;
use App\Repositories\Interfaces\IWarehouseGuideRepository;
use App\Repositories\Interfaces\IWarehouseGuideDetailRepository;
use App\Repositories\Interfaces\IProductRepository;
use App\Services\Interfaces\IWarehouseGuideService;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(IWarehouseRepository::class, WarehouseRepository::class);
        $this->app->bind(IUnitMeasureRepository::class, UnitMeasureRepository::class);
        $this->app->bind(IBrandRepository::class, BrandRepository::class);
        $this->app->bind(IModelRepository::class, ModelRepository::class);
        $this->app->bind(ITypeMovementRepository::class, TypeMovementRepository::class);
        $this->app->bind(IProductRepository::class, ProductRepository::class);
        $this->app->bind(IWarehouseGuideRepository::class, WarehouseGuideRepository::class);
        $this->app->bind(IWarehouseGuideDetailRepository::class, WarehouseGuideDetailRepository::class);
        $this->app->bind(IWarehouseGuideService::class, WarehouseGuideService::class);
    }
}
