<?php
namespace App\Repositories;

use Exception;
use App\Models\Brand;
use App\DTOs\Brands\BrandCreateDto;
use App\DTOs\Brands\BrandUpdateDto;
use App\Repositories\Interfaces\IBrandRepository;

class BrandRepository implements IBrandRepository
{
    public function paginate(array $request)
    {
        if ((isset($request['search'])) || (isset($request['orderby'])) || (isset($request['orderdir'])) || (isset($request['start'])) || (isset($request['length']))) {
            $orderBy = $request['orderby'];
            $orderDir = $request['orderdir'];
            $start = $request['start'];
            $length = $request['length'];

            if (isset($request['search'])) {
                $search = $request['search'];
    
                return Brand::orderBy($orderBy, $orderDir)
                    ->where('trademark', 'like', '%'.$search.'%')
                    ->skip($start)
                    ->take($length)
                    ->get();
            } else {
                return Brand::orderBy($orderBy, $orderDir)
                    ->skip($start)
                    ->take($length)
                    ->get();
            }            
        } else {
            return Brand::get();
        }               
    }

    public function find(int $id): ?Brand
    {
        return Brand::find($id);
    }

    public function store(BrandCreateDto $store): Brand
    {
        $entry = new Brand();

        $entry->code = $store->code;
        $entry->brand = $store->brand;

        $entry->save();

        return $entry;
    }

    public function update(BrandUpdateDto $store): void
    {
        $entry = Brand::find($store->id);

        $entry->code = $store->code;
        $entry->brand = $store->brand;

        $entry->save();
    }

    public function destroy(int $id): void
    {
        Brand::destroy($id);
    }
}
