<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use App\Models\WarehouseGuide;
use App\DTOs\WarehouseGuide\WarehouseGuideCreateDto;
use App\DTOs\WarehouseGuide\WarehouseGuideUpdateDto;
use App\Services\Interfaces\IWarehouseGuideService;
use App\Repositories\Interfaces\IWarehouseGuideRepository;
use App\Repositories\Interfaces\IWarehouseGuideDetailRepository;

class WarehouseGuideService implements IWarehouseGuideService {

    protected $warehouseguideRepository;

    public function __construct(IWarehouseGuideRepository $warehouseguideRepository, 
                                IWarehouseGuideDetailRepository $warehouseguidedetailRepository) {
        $this->warehouseguideRepository = $warehouseguideRepository;
        $this->warehouseguidedetailRepository = $warehouseguidedetailRepository;
    }

    public function paginate(array $request)
    {
        return $this->warehouseguideRepository->paginate($request);
    }

    public function find(int $id): ?WarehouseGuide
    {
        return $this->warehouseguideRepository->find($id);
    }

    public function store(WarehouseGuideCreateDto $store): void //WarehouseGuide
    {
        DB::connection('mysql_client')->beginTransaction();
        $details = (is_null($store->warehouseguide_detail) ? [] : json_decode($store->warehouseguide_detail));
        $store->except('warehouseguide_detail');
        $warehouseguide = $this->warehouseguideRepository->store($store);
        if( !is_null($warehouseguide) ){
            if( count($details) > 0 ){
                $this->storeRelation($warehouseguide, $details);
            }
            DB::connection('mysql_client')->commit();
        } else {
            DB::connection('mysql_client')->rollBack();
        }
        //return $warehouseguide;
    }

    public function storeRelation(WarehouseGuide $warehouseguide, $details): void
    {
        $warehouseguide_id = $warehouseguide->id;
        foreach( $details as $detail ){
            $detail->warehouseguide_id = $warehouseguide_id;
            $this->warehouseguidedetailRepository->store($detail);
        }
    }

    public function update(WarehouseGuideCreateDto $store): void
    {
        //$this->warehouseguideRepository->update($store);
        DB::connection('mysql_client')->beginTransaction();
        try{
            $this->destroy($store->id);
            $store->except('id');
            $this->store($store);
            DB::connection('mysql_client')->commit();
        } catch(\Exception $ex) {
            DB::connection('mysql_client')->rollBack();
        }
    }

    public function destroy(int $id): void
    {
        DB::connection('mysql_client')->beginTransaction();
        try{
            $warehouseguide = $this->warehouseguideRepository->find($id);
            $warehouseguide_details = $warehouseguide->details;
            $this->deleteRelation($warehouseguide, $warehouseguide_details);
            $this->warehouseguideRepository->destroy($id);
            DB::connection('mysql_client')->commit();
        } catch(\Exception $ex) {
            DB::connection('mysql_client')->rollBack();
        }
    }

    public function deleteRelation(WarehouseGuide $warehouseguide, $details): void
    {
        $warehouseguide_id = $warehouseguide->id;
        $guide_type = $warehouseguide->guide_type;
        foreach( $details as $detail ){
            $this->warehouseguidedetailRepository->destroy($detail->id, $guide_type);
        }
    }

}