<?php
namespace App\Models;

use App\Models\Entity;
use Illuminate\Database\Eloquent\SoftDeletes;

class WarehouseGuideDetail extends EntityDynamic
{
    use SoftDeletes;
    protected $table = 'tec_warehouseguide_detail';
    protected $casts = [
        'production_date' => 'datetime:d/m/Y',
        'expiration_date' => 'datetime:d/m/Y'
    ];

    public function seriesDetalle(){
        return $this->hasMany(WarehouseGuideDetailSerie::class, 'warehouseguide_detail_id', 'id');
    }

    public function productDetailsIn(){
        return $this->hasMany(ProductDetails::class, 'warehouseguide_detail_in_id', 'id');
    }

    public function productDetailsOut(){
        return $this->hasMany(ProductDetails::class, 'warehouseguide_detail_out_id', 'id');
    }

    public function movement(){
        return $this->hasOne(ProductMovement::class, 'warehouseguide_detail_id', 'id');
    }
}
