<?php
namespace App\Repositories\Interfaces;

use App\Models\TypeMovement;
use App\DTOs\TypesMovement\TypeMovementCreateDto;
use App\DTOs\TypesMovement\TypeMovementUpdateDto;

interface ITypeMovementRepository
{
    public function paginate(array $request);
    public function find(int $id): ?TypeMovement;
    public function store(TypeMovementCreateDto $store): TypeMovement;
    public function update(TypeMovementUpdateDto $store): void;
    public function destroy(int $id): void;
}
