<?php
namespace App\Repositories\Interfaces;

use App\Models\WarehouseGuide;
use App\DTOs\WarehouseGuide\WarehouseGuideCreateDto;
use App\DTOs\WarehouseGuide\WarehouseGuideUpdateDto;

interface IWarehouseGuideRepository
{
    public function paginate(array $request);
    public function find(int $id): ?WarehouseGuide;
    public function store(WarehouseGuideCreateDto $store): WarehouseGuide;
    public function update(WarehouseGuideUpdateDto $store): void;
    public function destroy(int $id): void;
}
