<?php
namespace App\Repositories;

use Exception;
use App\Models\UnitMeasure;
use Illuminate\Pagination\Paginator;
use App\DTOs\UnitMeasure\UnitMeasureCreateDto;
use App\DTOs\UnitMeasure\UnitMeasureUpdateDto;
use App\Repositories\Interfaces\IUnitMeasureRepository;

class UnitMeasureRepository implements IUnitMeasureRepository
{
    public function paginate(array $request)
    {
        /*$orderBy = isset($request['orderby']) ? $request['orderby'] : "";
        $orderDir = isset($request['orderdir']) ? $request['orderdir'] : "";
        $start = isset($request['start']) ? $request['start'] : "";
        $length = isset($request['length']) ? $request['length'] : "";
        $search = isset($request['search']) ? $request['search'] : "";

        if( $search != "" || $orderby != "" || $orderdir != "" || $start != "" || $length != "" ){
            
            $unit_measure = UnitMeasure::orderBy($orderBy, $orderDir);
            if( $search != "" ){
                $unit_measure = $unit_measure->where('description', 'like', '%'.$search.'%')
                    ->orWhere('code_sunat', 'like', '%'.$search.'%')
                    ->orWhere('description_fe', 'like', '%'.$search.'%');
            }
            return $unit_measure->skip($start)
                ->take($length)
                ->get();
        } else {
            return UnitMeasure::get();
        }*/
        
        if ((isset($request['search'])) || (isset($request['orderby'])) || 
        (isset($request['orderdir'])) || (isset($request['start'])) || (isset($request['length']))) {
            $orderBy = $request['orderby'];
            $orderDir = $request['orderdir'];
            $start = $request['start'];
            $length = $request['length'];

            if (isset($request['search'])) {
                $search = $request['search'];
    
                return UnitMeasure::orderBy($orderBy, $orderDir)
                    ->where('description', 'like', '%'.$search.'%')
                    ->orWhere('code_sunat', 'like', '%'.$search.'%')
                    ->orWhere('description_fe', 'like', '%'.$search.'%')
                    ->skip($start)
                    ->take($length)
                    ->get();
            } else {
                return UnitMeasure::orderBy($orderBy, $orderDir)
                    ->skip($start)
                    ->take($length)
                    ->get();
            }            
        } else {
            return UnitMeasure::get();
        } 
    }

    public function find(int $id): ?UnitMeasure
    {
        return UnitMeasure::find($id);
    }

    public function store(UnitMeasureCreateDto $store): UnitMeasure
    {
        $entry = new UnitMeasure();

        $entry->code = $store->code;
        $entry->description = $store->description;
        $entry->code_sunat = $store->code_sunat;
        $entry->description_fe = $store->description_fe;
        
        $entry->save();

        return $entry;
    }

    public function update(UnitMeasureUpdateDto $store): void
    {
        $entry = UnitMeasure::find($store->id);

        $entry->code = $store->code;
        $entry->description = $store->description;
        $entry->code_sunat = $store->code_sunat;
        $entry->description_fe = $store->description_fe;

        $entry->save();
    }

    public function destroy(int $id): void
    {
        UnitMeasure::destroy($id);
    }
}
