<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTecWarehouseguideTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tec_warehouseguide', function (Blueprint $table) {
            $table->engine = 'InnoDB';
            $table->bigIncrements('id');
            $table->string('guide_type')->nullable(); //INGRESO (I) - SALIDA (S)
            $table->integer("warehouse_id")->unsigned();
            $table->string('warehouse_name')->nullable();
            $table->date('date')->nullable();
            $table->date('date_tras')->nullable();
            $table->integer('supplier_id')->unsigned()->nullable();
            $table->string('supplier_name')->nullable();
            $table->integer('customer_id')->unsigned()->nullable();
            $table->string('customer_name')->nullable();
            $table->integer('payment_method_id')->unsigned();
            $table->integer('zone_id')->unsigned()->nullable();
            $table->string('order_number')->nullable();
            $table->string('docreference_number')->nullable();
            $table->text('observation')->nullable();
            $table->string('counter')->nullable(); // INTERNO - EXTERNO
            $table->string('guide_number')->nullable();
            $table->integer('movement_type_id')->unsigned();
            $table->integer('sucursal_id')->unsigned()->nullable();
            $table->string('currency')->nullable();
            $table->decimal('exchange', 8, 2)->default(0)->nullable();
            $table->string('status')->default('open'); //open - close
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tec_warehouseguide');
    }
}
