<?php
namespace App\Repositories\Interfaces;

use App\Models\Categories;
use App\DTOs\Categories\CategoriesCreateDto;
use App\DTOs\Categories\CategoriesUpdateDto;

interface ICategoriesRepository
{
    public function paginate(array $request);
    public function find(int $id): ?Categories;
    public function store(CategoriesCreateDto $store): Categories;
    public function update(CategoriesUpdateDto $store): void;
    public function destroy(int $id):void; 
}