<?php
namespace App\Repositories\Interfaces;

use App\Models\Brand;
use App\DTOs\Brands\BrandCreateDto;
use App\DTOs\Brands\BrandUpdateDto;

interface IBrandRepository
{
    public function paginate(array $request);
    public function find(int $id): ?Brand;
    public function store(BrandCreateDto $store): Brand;
    public function update(BrandUpdateDto $store): void;
    public function destroy(int $id): void;
}
