<?php
namespace App\Repositories\Interfaces;

use App\Models\UnitMeasure;
use Illuminate\Pagination\Paginator;
use App\DTOs\UnitMeasure\UnitMeasureCreateDto;
use App\DTOs\UnitMeasure\UnitMeasureUpdateDto;

interface IUnitMeasureRepository
{
    public function paginate(array $request);
    public function find(int $id): ?UnitMeasure;
    public function store(UnitMeasureCreateDto $store): UnitMeasure;
    public function update(UnitMeasureUpdateDto $store): void;
    public function destroy(int $id): void;
}