<?php
namespace App\Repositories;

use Exception;
use App\Models\Makers;
use App\DTOs\Makers\MakersCreateDto;
use App\DTOs\Makers\MakersUpdateDto;
use App\Repositories\Interfaces\IMakersRepository;

class MakersRepository implements IMakersRepository
{
    public function paginate(array $request)
    {

        if ((isset($request['search'])) || (isset($request['orderby'])) || (isset($request['orderdir'])) || (isset($request['start'])) || (isset($request['length']))) {
        $orderBy = $request['orderby'];
        $orderDir = $request['orderdir'];
        $start = $request['start'];
        $length = $request['length'];
        $query = Makers::orderBy($orderBy, $orderDir);

        if(isset($request['search'])) {
            $search = $request['search'];
            $query = $query->where('maker', 'like', '%'.$search.'%');
        }
        $makers_count = $query->count();
        $makers = $query->skip($start)->take($length);
        $makers = $makers->get();

    } else {
        $br = Makers::query();
        $makers_count = $br->count();
        $makers = $br->get();
    }
    $respuesta['total'] = $makers_count;
    $respuesta['list'] = $makers;

    return $respuesta;

    }

    public function find(int $id): ?Makers
    {
        return Makers::find($id);
    }

    public function store(MakersCreateDto $store): Makers
    {
        $entry = new Makers();

        $entry->maker = $store->maker;

        $entry->save();

        return $entry;
    }

    public function update(MakersUpdateDto $store):void
    {
        $entry = Makers::find($store->id);

        $entry->maker = $store->maker;

        $entry->save();
    }

    public function destroy(int $id): void
    {
        Makers::destroy($id);
    }
}
