<?php
namespace App\Repositories;

use Exception;
use App\Models\WarehouseGuide;
use App\DTOs\WarehouseGuide\WarehouseGuideCreateDto;
use App\DTOs\WarehouseGuide\WarehouseGuideUpdateDto;
use App\Repositories\Interfaces\IWarehouseGuideRepository;
use Carbon\Carbon;
use Illuminate\Support\Facades\Log;

class WarehouseGuideRepository implements IWarehouseGuideRepository
{
    public function paginate(array $request)
    {
        $response = [];
        $warehouseguide_count = "";

        $typeGuide = ( isset($request['type']) ? $request['type'] : "" );
        $warehouseguide = WarehouseGuide::query();
        if( $typeGuide != "" ){
            $warehouseguide->where('guide_type', '=', $typeGuide);
        }
        Log::debug(json_encode($request));
        if ((isset($request['search'])) || (isset($request['orderby'])) || 
            (isset($request['orderdir'])) || (isset($request['start'])) || 
            (isset($request['length']))
        ) { 
            $orderBy = $request['orderby'];
            $orderDir = $request['orderdir'];
            $start = $request['start'];
            $length = $request['length'];

            if (isset($request['search']) && $request['search'] != "" ) {
                $search = $request['search'];
                $warehouseguide->where('guide_number', 'like', '%'.$search.'%');
            }

            $warehouseguide_count = $warehouseguide->count();
            $whg = $warehouseguide->orderBy($orderBy, $orderDir)
                ->skip($start)
                ->take($length)
                ->get();
        } else {
            $warehouseguide_count = $warehouseguide->count();
            $whg = $warehouseguide->get();
        }

        $response['total'] = $warehouseguide_count;
        $response['list'] = $whg;

        return $response;
    }

    public function find(int $id): ?WarehouseGuide
    {
        /*$entry = WarehouseGuide::with(['details.series' => function($query){
            $query->pluck('serie_number');
        }])->find($id);
        return $entry;*/
        $warehouseguide_detail_series = WarehouseGuide::find($id);
        //return $warehouseguide_detail_series[];
        if( $warehouseguide_detail_series ){
            foreach( $warehouseguide_detail_series->details as &$detail_series ){
                $series_numbers = [];
                $movement = $detail_series->movement;
                foreach( $detail_series->seriesDetalle as $serie ){
                    $series_numbers[] = $serie->serie_number;
                }
                $detail_series->local_id = $movement->local_id;
                $detail_series->userguide_id = $movement->uCrea;
                $detail_series->series = $series_numbers;
            }
        }
        return $warehouseguide_detail_series;
        //return WarehouseGuide::with('details.series')->find($id);
    }

    public function store(WarehouseGuideCreateDto $store): WarehouseGuide
    {
        $entry = new WarehouseGuide();

        $entry->guide_type = $store->guide_type; // I o S mayúscula
        $entry->warehouse_id = $store->warehouse_id;
        $entry->warehouse_name = $store->warehouse_name;
        $entry->date = (is_null($store->date) || $store->date == "" ? 
            $store->date : 
            Carbon::createFromFormat('d/m/Y', $store->date)->format('Y-m-d'));
        $entry->date_tras = (is_null($store->date_tras) || $store->date_tras == "" ? 
            $store->date_tras : 
            Carbon::createFromFormat('d/m/Y', $store->date_tras)->format('Y-m-d'));
        $entry->supplier_id = $store->supplier_id;
        $entry->supplier_name = $store->supplier_name;
        $entry->customer_id = $store->customer_id;
        $entry->customer_name = $store->customer_name;
        $entry->payment_method_id = $store->payment_method_id;
        $entry->zone_id = $store->zone_id;
        $entry->order_number = $store->order_number;
        $entry->docreference_number = $store->docreference_number;
        $entry->observation = $store->observation;
        $entry->counter = $store->counter;
        $entry->guide_number = $store->guide_number;
        $entry->movement_type_id = $store->movement_type_id;
        $entry->sucursal_id = $store->sucursal_id;
        $entry->currency = $store->currency;
        $entry->exchange = $store->exchange;
        $entry->save();

        return $entry;
    }

    public function update(WarehouseGuideUpdateDto $store): void
    {
        $entry = WarehouseGuide::find($store->id);

        $entry->guide_type = $store->guide_type;
        $entry->warehouse_id = $store->warehouse_id;
        $entry->warehouse_name = $store->warehouse_name;
        $entry->date = (is_null($store->date) || $store->date == "" ? 
            $store->date : 
            Carbon::createFromFormat('d/m/Y', $store->date)->format('Y-m-d'));
        $entry->date_tras = (is_null($store->date_tras) || $store->date_tras == "" ? 
            $store->date_tras : 
            Carbon::createFromFormat('d/m/Y', $store->date_tras)->format('Y-m-d'));
        $entry->supplier_id = $store->supplier_id;
        $entry->supplier_name = $store->supplier_name;
        $entry->customer_id = $store->customer_id;
        $entry->customer_name = $store->customer_name;
        $entry->payment_method_id = $store->payment_method_id;
        $entry->zone_id = $store->zone_id;
        $entry->order_number = $store->order_number;
        $entry->docreference_number = $store->docreference_number;
        $entry->observation = $store->observation;
        $entry->counter = $store->counter;
        $entry->guide_number = $store->guide_number;
        $entry->movement_type_id = $store->movement_type_id;
        $entry->sucursal_id = $store->sucursal_id;
        $entry->currency = $store->currency;
        $entry->exchange = $store->exchange;

        $entry->save();
    }

    public function destroy(int $id): void
    {
        WarehouseGuide::destroy($id);
    }
}
