<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});


$router->group(['prefix' => 'api/v1/'], function ($app) {
    $app->group(['prefix' => 'supplier'], function () use ($app) {
        $app->get('/', 'SupplierController@index');
        $app->get('/{id}', 'SupplierController@show');
        $app->post('/', 'SupplierController@store');
        $app->put('/{id}', 'SupplierController@update');
        $app->delete('/{id}', 'SupplierController@destroy');
    });

    $app->group(['prefix' => 'purchase_order'], function () use ($app) {
        $app->get('/', 'PurchaseOrderController@index');
        $app->get('/{id}', 'PurchaseOrderController@show');
        $app->post('/', 'PurchaseOrderController@store');
        $app->put('/{id}', 'PurchaseOrderController@update');
        $app->delete('change_estado/{id}', 'PurchaseOrderController@change_estado');
        $app->delete('/{id}', 'PurchaseOrderController@destroy');
    });
});