DELIMITER $$

DROP PROCEDURE IF EXISTS `apiadministrador`.`SP_ADMIN_ELIMINAR_EMPRESAS`$$

CREATE  PROCEDURE SP_ADMIN_ELIMINAR_EMPRESAS(
	IN 			pint_id_empresas 			INT
)
BEGIN
	DECLARE 	int_id_persona 					INTEGER 		DEFAULT 		0;
	DECLARE 	int_id_persona_contacto 		INTEGER 		DEFAULT 		0;
	DECLARE 	var_mensaje 					VARCHAR(255) 		DEFAULT 		"";
/****************OBTENER EL ID DE LA PERSONA PERTENECIENTE A LA EMPRESA******************************/
	set int_id_persona=(SELECT id_persona 
							FROM empresas 
								WHERE id_empresa=pint_id_empresas);
/****************OBTENER EL ID DE LA PERSONA DE CONTACTO*********************************************/
	set int_id_persona_contacto=(SELECT id_persona 
									FROM contactos 
										WHERE id_empresa=pint_id_empresas);
/****************ACTUALIZAMOS EL ESTADO DE LA EMPRESA Y PERSONA*************************************/
	UPDATE empresas 
		SET status=0 
			WHERE id_empresa=pint_id_empresas;
	UPDATE personas 
		set status=0 
			WHERE id_persona=int_id_persona;
	/*********VALIDAMOS SI EL ID DE LA PERSONA DE CONTACTO ES IGUAL A LA PERSONA DE EMPRESA*********/	
	IF (int_id_persona != int_id_persona_contacto) THEN	
		UPDATE personas 
			SET status=0 
				WHERE id_persona=int_id_persona_contacto;
	END IF;
	/************************ACTUALIZAMOS EL ESTADO DEL CONTACTO************************************/		
	UPDATE contactos 
		SET status=0 
			WHERE id_empresa=pint_id_empresas;
	SELECT 'Empresa eliminada con exito ' AS mensaje;
END$$

DELIMITER ;