<?php

namespace App\Repositories;
use App\TicketModel;

use Illuminate\Support\Facades\DB;
use App\Repositories\Interfaces\ITicketRepository;

class TicketRepository implements ITicketRepository
{
    public function paginate($ruc, array $request)
{
    
   
        $query = TicketModel::select(
            'tickets.id_ticket',
            'tickets.numero',
            'tickets.fec_emision',
            'tickets.fec_periodo_ini',
            'tickets.fec_periodo_fin',
            'tickets.fec_vencimiento',
            'tickets.imp_total',
            'tickets.fec_pago',
            'tickets.estado'
        )
        ->join('empresas', 'empresas.id_empresa', '=', 'tickets.id_empresa')
        ->join('personas', 'personas.id_persona', '=', 'empresas.id_persona');
         

        if (isset($request['search'])) {
            $search = $request['search'];
            $query->where(function ($subquery) use ($search) {
                $subquery->where('tickets.numero', 'like', '%' . $search . '%')
                    ->orWhere('tickets.fec_emision', 'like', '%' . $search . '%')
                    ->orWhere('tickets.fec_periodo_ini', 'like', '%' . $search . '%')
                    ->orWhere('tickets.fec_periodo_fin', 'like', '%' . $search . '%')
                    ->orWhere('tickets.fec_vencimiento', 'like', '%' . $search . '%')
                    ->orWhere('tickets.imp_total', 'like', '%' . $search . '%')
                    ->orWhere('tickets.fec_pago', 'like', '%' . $search . '%')
                    ->orWhere('tickets.flg_reconexion', 'like', '%' . $search . '%')
                    ->orWhere('tickets.estado', 'like', '%' . $search . '%');
            });
        }

        if (isset($request['orderby'])) {
            $orderBy = $request['orderby'];
            $orderDir = isset($request['orderdir']) ? $request['orderdir'] : 'asc';
            $query->orderBy($orderBy, $orderDir);
        }

        if (isset($request['filters']) && !empty($request['filters']['estado'])) {
            $query->where('tickets.estado', $request['filters']['estado']);
        }
        
        $total = $query->where('personas.num_documento', $ruc)->count();

        if (isset($request['start']) && isset($request['length'])) {
            $start = $request['start'];
            $length = $request['length'];
            $query->skip($start)->take($length);
        }

        $tickets = $query->where('personas.num_documento', $ruc)->get();

        return [
            'list' => $tickets,
            'total' => $total,
        ];  
    }
    public function find($id_ticket)
    {
        try {
            $detallesTicket = DB::table('tickets_det as td')
            ->join('tickets as t', 'td.id_ticket', '=', 't.id_ticket')
            ->select(
                    'td.id_ticket_det',
                    'td.id_ticket',
                    'td.cantidad',
                    'td.descripcion',
                    'td.importe'
                )
                ->where('td.id_ticket', $id_ticket)
                ->get();
    
            return $detallesTicket;
        } catch (\Throwable $th) {
            return response()->json(['error' => 'Error al obtener los detalles del ticket.'], 500);
        }
    }
    
}