<?php
namespace App\Models;

use App\Models\Entity;
use App\Models\WarehouseGuideDetail;
use Illuminate\Database\Eloquent\SoftDeletes;

class WarehouseGuide extends EntityDynamic
{
    use SoftDeletes;
    protected $table = 'tec_warehouseguide';
    protected $casts = [
        'date' => 'datetime:d/m/Y',
        'date_tras' => 'datetime:d/m/Y'
    ];

    public function details(){
        return $this->hasMany(WarehouseGuideDetail::class, 'warehouseguide_id', 'id');
    }
}
