<?php
namespace App\Repositories\Interfaces;

use App\Models\Makers;
use App\DTOs\Makers\MakersCreateDto;
use App\DTOs\Makers\MakersUpdateDto;

interface IMakersRepository
{
    public function paginate(array $request);
    public function find(int $id): ?Makers;
    public function store(MakersCreateDto $store): Makers;
    public function update(MakersUpdateDto $store): void;
    public function destroy(int $id): void;
}