<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It is a breeze. Simply tell Lumen the URIs it should respond to
| and give it the Closure to call when that URI is requested.
|
*/

$router->get('/', function () use ($router) {
    return $router->app->version();
});

$router->group(['prefix' => 'api/v1/'], function ($app) {
    $app->group(['prefix' => 'warehouses'], function () use ($app) {
        $app->get('/', 'WarehouseController@index');
        $app->get('/{id}', 'WarehouseController@show');
        $app->post('/', 'WarehouseController@store');
        $app->put('/{id}', 'WarehouseController@update');
        $app->delete('/{id}', 'WarehouseController@destroy');
    });

    $app->group(['prefix' => 'brands'], function () use ($app) {
        $app->get('/', 'BrandController@index');
        $app->get('/{id}', 'BrandController@show');
        $app->post('/', 'BrandController@store');
        $app->put('/{id}', 'BrandController@update');
        $app->delete('/{id}', 'BrandController@destroy');
    });

    $app->group(['prefix' => 'models'], function () use ($app) {
        $app->get('/', 'ModelController@index');
        $app->get('/{id}', 'ModelController@show');
        $app->post('/', 'ModelController@store');
        $app->put('/{id}', 'ModelController@update');
        $app->delete('/{id}', 'ModelController@destroy');
    });

    $app->group(['prefix' => 'types_movement'], function () use ($app) {
        $app->get('/', 'TypeMovementController@index');
        $app->get('/{id}', 'TypeMovementController@show');
        $app->post('/', 'TypeMovementController@store');
        $app->put('/{id}', 'TypeMovementController@update');
        $app->delete('/{id}', 'TypeMovementController@destroy');
    });

    $app->group(['prefix' => 'warehouseguide'], function () use ($app) {
        $app->get('/', 'WarehouseGuideController@index');
        $app->get('/{id}', 'WarehouseGuideController@show');
        $app->post('/', 'WarehouseGuideController@store');
        $app->put('/{id}', 'WarehouseGuideController@update');
        $app->delete('/{id}', 'WarehouseGuideController@destroy');
    });

    /*$app->group(['prefix' => 'warehouseguide_detail'], function () use ($app) {
        $app->get('/', 'WarehouseGuideDetailController@index');
        $app->get('/{id}', 'WarehouseGuideDetailController@show');
        $app->post('/', 'WarehouseGuideDetailController@store');
        $app->put('/{id}', 'WarehouseGuideDetailController@update');
        $app->delete('/{id}', 'WarehouseGuideDetailController@destroy');
    });*/

    $app->group(['prefix' => 'products'], function () use ($app) {
        $app->get('/', 'ProductController@index');
        $app->get('/{id}', 'ProductController@show');
        $app->post('/', 'ProductController@store');
        $app->put('/{id}', 'ProductController@update');
        $app->delete('/{id}', 'ProductController@destroy');
    });

    $app->group(['prefix' => 'unitmeasure'], function () use ($app) {
        $app->get('/', 'UnitMeasureController@index');
        $app->get('/{id}', 'UnitMeasureController@show');
        $app->post('/', 'UnitMeasureController@store');
        $app->put('/{id}', 'UnitMeasureController@update');
        $app->delete('/{id}', 'UnitMeasureController@destroy');
    });

    $app->group(['prefix' => 'categories'], function () use ($app) {
        $app->get('/', 'CategoriesController@index');
        $app->get('/{id}', 'CategoriesController@show');
        $app->post('/', 'CategoriesController@store');
        $app->put('/{id}', 'CategoriesController@update');
        $app->delete('/{id}', 'CategoriesController@destroy');
    });

    $app->group(['prefix' => 'makers'], function () use ($app) {
        $app->get('/', 'MakersController@index');
        $app->get('/{id}', 'MakersController@show');
        $app->post('/', 'MakersController@store');
        $app->put('/{id}', 'MakersController@update');
        $app->delete('/{id}', 'MakersController@destroy');
    });
});