<?php

namespace App\Http\Controllers;

use App\Models\Ubigeo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Laravel\Lumen\Http\Request as HttpRequest;

class UbigeoController extends Controller
{
    
   public function __construct()
    {
        
    }
    
    public function departamentList(){
        $dataset = (object)[];
        $departamentos = Ubigeo::select(DB::raw('left(ubigeo,2) as codDepa, departamento'))
                            ->distinct()
                            ->get();

        if(!empty($departamentos)){
         
            $dataset->result="ok";
            $dataset->messaje="Lista de departamentos";
            $dataset->data = $departamentos;

            
        }else{
            $dataset->result="failed";
            $dataset->messaje="No se encontro departamentos";
        }
        return json_encode($dataset);
    }
    public function provinceList(Request $request ){
        $dataset =(object)[];
        $data = $request->all() ;
        $codDepartament = $data['codDepartamento'];
        $provincias = Ubigeo::select(DB::raw('left(ubigeo,4) as codProv, provincia'))
                        ->distinct()
                        ->where(DB::raw('left(ubigeo,2)'), '=', $codDepartament)
                        ->get();
        if(!empty($provincias)){
            
            $dataset->result="ok";
            $dataset->messaje="Lista de provincias";
            $dataset->data = $provincias;

            
        }else{
            $dataset->result="failed";
            $dataset->messaje="No se encontro provincias";
        }
        return json_encode($dataset);
    }
    public function districtList(Request $request){
        $dataset =(object)[];
        $data = $request->all() ;
        $codProvincia = $data['codProvincia'];
        $distritos = Ubigeo::select('ubigeo','distrito')
            ->distinct()
            ->where(DB::raw('left(ubigeo,4)'), '=', $codProvincia)
            ->get();

        if(!empty($distritos)){
        
            $dataset->result="ok";
            $dataset->messaje="Lista de distritos ".(count($distritos));
            $dataset->data = $distritos;

            
        }else{
            $dataset->result="failed";
            $dataset->messaje="No se encontro distritos";
        }
        return json_encode($dataset);
    }
}

?>