<?php
namespace App\Providers;

use App\Repositories\PaymentMethodRepository;
use Illuminate\Support\ServiceProvider;
use App\Repositories\Interfaces\IPaymentMethodRepository;
use App\Repositories\Interfaces\ISettingRepository;
use App\Repositories\SettingRepository;
use App\Repositories\Interfaces\IAffectationTypeRepository;
use App\Repositories\AffectationTypeRepository;

class RepositoryServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->app->bind(IPaymentMethodRepository::class, PaymentMethodRepository::class);
        $this->app->bind(ISettingRepository::class, SettingRepository::class);
        $this->app->bind(IAffectationTypeRepository::class, AffectationTypeRepository::class);
    }
}
