<?php

namespace App\Http\Controllers;

use App\Models\PaymentType;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Validator;

use Exception;


class PaymentTypeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    public function index(Request $request){
       
        try{

            if ((isset($request['search'])) || (isset($request['orderby'])) || (isset($request['orderdir'])) || (isset($request['start'])) || (isset($request['length']))) {
                $orderBy = $request['orderby'];
                $orderDir = $request['orderdir'];
                $start = $request['start'];
                $length = $request['length'];
                $query=$PaymentTypes = PaymentType::orderBy($orderBy, $orderDir);
                if (isset($request['search'])) {
                    $search = $request['search'];
                    $query=$query->where('description', 'like', '%'.$search.'%');
                } 
                $query=$query->skip($start)->take($length);
                $pay_count=$query->count();
                $PaymentTypes=$query->skip($start)->take($length);
                $PaymentTypes=$PaymentTypes->get();         
            } else {
                $pay = PaymentType::query();
                $pay_count=$pay->count();
                $PaymentTypes = $pay->get(); 
            } 
            $respuesta['total']=$pay_count;
            $respuesta['list']=$PaymentTypes;
             if( count($PaymentTypes) > 0){
                 return $this->successResponse($respuesta, "", 201);
             } else {
                 return $this->successResponse($respuesta,"No hay Tipos de Pago cargados en el sistema.", 201);
             }

         } catch(\Exception $ex){
             return $this->messageError("Ocurrió un error al buscar los Tipos de Pago cargados en el sistema.", 201);
         }
    }

    public function show(int $id){
       try{
           if($id != ""){
                $PaymentType= PaymentType::find($id);
           }else{
                $PaymentType=null;
           }
            
            if( $PaymentType === null){
                return $this->messageError("No hay datos para el Tipo de Pago buscado.", 201);
            } else {
                return $this->successResponse($PaymentType, "", 201);
            }
        } catch(\Exception $ex){
            return $this->messageError("Ocurrió un error al buscar los Tipos de Pago cargados en el sistema.", 201);
        }
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @return \Illuminate\Http\Response
     * @throws \Illuminate\Validation\ValidationException
     */
    public function store(Request $request){

       
        try{
            $rules = [
                'code' => ['required','unique:payment_types','max:4','regex:/^[A-Za-z0-9 ]+$/'],
                'code_sunat' => ['required','digits_between:1,10','integer'],
                'description' => ['max:200','regex:/^([0-9a-zA-ZñÑáéíóúÁÉÍÓÚ_-])+((\s*)+([0-9a-zA-ZñÑáéíóúÁÉÍÓÚ_-]*)*)+$/']
            ];
            $messages = [
                'code.required' => 'El código de Tipo de Pago no puede estar vacío.',
                'code.unique' =>'El código de Tipo de Pago debe ser único',
                'code.max' =>'El código de Tipo de Pago no puede superar los :max caracteres',
                'code.regex' =>'El código de Tipo de Pago no puede contenter caracteres espaciales.',
                'code_sunat.required' => 'El código de SUNAT no puede estar vacío.',
                'code_sunat.digits_between' =>'El código SUNAT no puede superar los :max caracteres',
                'code_sunat.integer' =>'El código SUNAT debe ser un número entero',
                'description.regex' => 'La descripción no puede tener caracteres.',
                'description.max' => 'La Descripción no puede superar los :max caracteres.'
            ];
            $this->validate($request, $rules, $messages);
            $input = $request->all();
            $PaymentType = PaymentType::create($input);
            if( !is_null($PaymentType) ){
                return $this->successResponse($PaymentType, "El Tipo de Pago se creó correctamente", 201);
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 201);
        } catch(\Exception $ex){

        }        

        return $this->messageError("Ocurrió un error creando el Tipo de Pago.", 201);
    }


    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request $request
     * @param  int $id
     * @return \Illuminate\Http\Response
     * @throws \Illuminate\Validation\ValidationException
     */
    public function update(Request $request, $id)
    {
        try{
            $rules = [
                'code' => ['required', 'max:4','regex:/^[A-Za-z0-9 ]+$/','unique:payment_types,code,'.$id],
                'code_sunat' => ['required','digits_between:1,10','integer'],
                'description' => ['max:200','regex:/^([0-9a-zA-ZñÑáéíóúÁÉÍÓÚ_-])+((\s*)+([0-9a-zA-ZñÑáéíóúÁÉÍÓÚ_-]*)*)+$/']
            ];
            $messages = [
                'code.required' => 'El código de Tipo de Pago no puede estar vacío.',
                'code.unique' =>'El código de Tipo de Pago debe ser único',
                'code.max' =>'El código de Tipo de Pago no puede superar los :max caracteres',
                'code.regex' =>'El código de Tipo de Pago no puede contenter caracteres espaciales.',
                'code_sunat.required' => 'El código de SUNAT no puede estar vacío.',
                'code_sunat.digits_between' =>'El código SUNAT no puede superar los :max caracteres',
                'code_sunat.integer' =>'El código SUNAT debe ser un número entero',
                'description.regex' => 'La descripción no puede tener caracteres.',
                'description.max' => 'La Descripción no puede superar los :max caracteres.'
            ];
            $this->validate($request, $rules, $messages);
            $PaymentType = PaymentType::find($id);
            if( !is_null($PaymentType) ) {
                if ($PaymentType->fill($request->all())->save()) {
                    return $this->successResponse($PaymentType, "El Tipo de Pago se actualizó correctamente", 201);
                }
            } else {
                return $this->messageError("No existe el Tipo de Pago que desa actualizar.", 201);
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 201);
        } catch(\Exception $ex){

        }  
        return $this->messageError("Ocurrió un error al actualizar el Tipos de Pago.", 201);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try{
            if( PaymentType::destroy($id) ){
                return $this->messageSuccess("El Tipo de Pago se eliminó correctamente", 201);
            } else {
                return $this->messageError("No se pudo eliminar el Tipo de Pago.", 201);
            }
        } catch(\Exception $ex) {
            return $this->messageError("Ocurrió un error al eliminar el Tipo de Pago.", 201);
        }
    }

}
