<?php
namespace App\Repositories;

use Exception;
use App\Models\AffectationType;
use App\Repositories\Interfaces\IAffectationTypeRepository;

class AffectationTypeRepository implements IAffectationTypeRepository
{
    public function get()
    {
        return AffectationType::select('id','descripcion','codigo_sunat','tipo_afectacion')->where('status',1)->get();
        
    }

    public function find(int $id): ?AffectationType
    {
        $result = AffectationType::select('id', 'descripcion', 'codigo_sunat', 'tipo_afectacion')
            ->where('id', $id)
            ->where('status', 1)
            ->first();
        return $result ? $result : null;
    }

}
