<?php
namespace App\Repositories;

use Exception;
use App\Models\OperationType;
use App\Repositories\Interfaces\IOperationTypeRepository;

class OperationTypeRepository implements IOperationTypeRepository
{
    public function get(array $request)
    {
        return OperationType::select('id', 'code', 'status', 'tipo')
            ->where('status', 1)
            ->get();
    }

    public function find(int $id): ?OperationType
    {
        return OperationType::select('id', 'code', 'status', 'tipo')
        ->where('id', $id)
        ->where('status', 1)
        ->first();
    }

}
