<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\DTOs\Customer\CustomerCreateDto;
use App\DTOs\Customer\CustomerUpdateDto;
use App\Repositories\Interfaces\ICustomerRepository;
use Exception;
use App\Models\Customer;
use App\Repositories\Interfaces\IReportRepository;
use Symfony\Component\HttpKernel\Controller\ArgumentResolver\RequestValueResolver;

class ReportController extends Controller
{

    private $iReportRepository;
    private $errorConnection = "";

    public function __construct(Request $request, IReportRepository $iReportRepository)
    {
        if (isset($request['business_information'])) {
            $business_information = $request['business_information'];
            $ruc = $business_information['ruc_number'];

            $existe_conexion = $this->setDBClient($ruc);

            if ($existe_conexion['error']) {
                $this->errorConnection = $existe_conexion['message'];
                return $this->messageError("Se espera un número de RUC válido.", 201);
            } else {
                $this->iReportRepository = $iReportRepository;
            }
        } else {
            $this->errorConnection = 'Error en la conexión. Se espera número de RUC';
        }
    }


    public function getListAllSAles(Request $request)
    {
        try {
            $this->validate($request, [
                'filters.date_start' => 'nullable|date_format:d-m-Y',
                'filters.date_end' => 'nullable|date_format:d-m-Y',
                'filters.customer_id' => 'nullable|numeric',
                'filters.local_id' => 'nullable|numeric',
            ],[
                "filters.date_start.date_format" =>  "El formato de la fecha de inicio debe ser dd-mm-AAAA.",
                "filters.date_end.date_format" =>  "El formato de la fecha de fin debe ser dd-mm-AAAA.",
                "filters.customer_id.numeric" =>  "El identificador del cliente debe ser numérico.",
                "filters.local_id.numeric" =>  "El identificador del local debe ser numérico."
            ]);

            $requestData = $request->all();

            if ($this->errorConnection != '') {
                return $this->messageError($this->errorConnection, 201);
            }
            $data = $this->iReportRepository->getReportSales($requestData);


            if (!empty($data)) {
                return $this->successResponse($data, "Lista de comprobantes encontrado satisfactoriamente", 200);
            } else {
                return $this->successResponse([], "Lista de comprobantes encontrado satisfactoriamente", 200);
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 422);
        }
    }
    public function salesReport(Request $request)
    {
        try {
            $this->validate($request, [
                'filters.date_start' => 'nullable|date_format:d-m-Y',
                'filters.date_end' => 'nullable|date_format:d-m-Y',
                'filters.customer_id' => 'nullable|numeric',
                'filters.local_id' => 'nullable|numeric',
            ],[
                "filters.date_start.date_format" =>  "El formato de la fecha de inicio debe ser dd-mm-AAAA.",
                "filters.date_end.date_format" =>  "El formato de la fecha de fin debe ser dd-mm-AAAA.",
                "filters.customer_id.numeric" =>  "El identificador del cliente debe ser numérico.",
                "filters.local_id.numeric" =>  "El identificador del local debe ser numérico."
            ]);

            $requestData = $request->all();

            if ($this->errorConnection != '') {
                return $this->messageError($this->errorConnection, 201);
            }

            $data = [];

            if (isset($requestData['tab']['facturas']) && $requestData['tab']['facturas'] == 1) {
                $data['facturas'] = $this->iReportRepository->getFacturas($requestData);
            }

            if (isset($requestData['tab']['boletas']) && $requestData['tab']['boletas'] == 1) {
                $data['boletas'] = $this->iReportRepository->getBoletas($requestData);
            }

            if (isset($requestData['tab']['notas_ventas']) && $requestData['tab']['notas_ventas'] == 1) {
                $data['notas_ventas'] = $this->iReportRepository->getSalesNote($requestData);
            }

            if (isset($requestData['tab']['notas_credito']) && $requestData['tab']['notas_credito'] == 1) {
                $data['notas_credito'] = $this->iReportRepository->getCreditNote($requestData);
            }

            if (isset($requestData['tab']['notas_debito']) && $requestData['tab']['notas_debito'] == 1) {
                $data['notas_debito'] = [];
            }

            if (!empty($data)) {
                return $this->successResponse($data, "Lista de comprobantes", 200);
            } else {
                return $this->successResponse([], "Lista de comprobantes encontrados", 200);
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 422);
        }
    }
    public function reportSire(Request $request){
        try {
            $this->validate($request, [
                'filters.date_start' => 'nullable|date_format:d-m-Y',
                'filters.date_end' => 'nullable|date_format:d-m-Y',
                'filters.customer_id' => 'nullable|numeric',
                'filters.local_id' => 'nullable|numeric',
            ],[
                "filters.date_start.date_format" =>  "El formato de la fecha de inicio debe ser dd-mm-AAAA.",
                "filters.date_end.date_format" =>  "El formato de la fecha de fin debe ser dd-mm-AAAA.",
                "filters.customer_id.numeric" =>  "El identificador del cliente debe ser numérico.",
                "filters.local_id.numeric" =>  "El identificador del local debe ser numérico."
            ]);

            $requestData = $request->all();

            if ($this->errorConnection != '') {
                return $this->messageError($this->errorConnection, 201);
            }

            $data = $this->iReportRepository->reportSireRVIE($requestData);


            if (!empty($data)) {
                return $this->successResponse($data, "Lista de comprobantes", 200);
            } else {
                return $this->successResponse([], "Lista de comprobantes encontrados", 200);
            }
        } catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 422);
        }
    }
}
