<?php
namespace App\Repositories\Interfaces;

use App\Models\CustomerType;
use App\DTOs\CustomerType\CustomerTypeCreateDto;
use App\DTOs\CustomerType\CustomerTypeUpdateDto;

interface ICustomerTypeRepository
{
    public function paginate(array $request);
    public function find(int $id, string $ruc_business): ?CustomerType;
    public function store(CustomerTypeCreateDto $store): CustomerType;
    public function update(CustomerTypeUpdateDto $store): void;
    public function destroy(int $id): void;
}
