<?php
namespace App\Repositories\Interfaces;

use App\Models\Quota;
use App\DTOs\Quota\QuotaCreateDto;
use App\DTOs\Quota\QuotaUpdateDto;

interface IQuotaRepository
{
    public function paginate(array $request);
    public function find(int $id): ?Quota;
    public function findBySale(int $idSales);
    public function store(QuotaCreateDto $store): Quota;
    public function update(QuotaUpdateDto $store): void;
    public function destroy(int $id): void;
    public function destroyQuotaBySale(int $saleId, string $ruc): void;
}
