<?php
namespace App\Repositories\Interfaces;

use App\Models\Customer;
use App\DTOs\Customer\CustomerCreateDto;
use App\DTOs\Customer\CustomerUpdateDto;

interface ICustomerRepository
{
    public function paginate(array $request);
    public function find(int $id): ?Customer;
    public function store(CustomerCreateDto $store): Customer;
    public function update(CustomerUpdateDto $store): void;
    public function destroy(int $id): void;
}
