<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include "../controllers/validaciondedatos.php";
include "../controllers/procesarcomprobante.php";

error_reporting(E_ALL ^ E_NOTICE);
// para aceptar la conexión desde cualquier origen
header("Access-Control-Allow-Origin: *");

// Permite los métodos GET, POST, PUT, DELETE
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
//exit();
//obtenemos la data de la solicitud
$bodyRequest = file_get_contents("php://input");

// Decodificamos y lo guardamos en un array
$data = json_decode($bodyRequest, true);

$array_emisor = get_array_emisor($data);
$array_detalle = get_array_detalle($data);
$array_cabecera = get_array_cabecera($data, $array_emisor);
$tipodeproceso = (isset($array_emisor['tipo_proceso'])) ? $array_emisor['tipo_proceso'] : "1";

$url_base = '../archivos_xml_sunat/FE/';


$nombre_archivo = $array_emisor['ruc'] . '-' . $array_cabecera['COD_TIPO_DOCUMENTO'] . '-' . $data['header']['NRO_COMPROBANTE'];

if ($tipodeproceso == '0') {
	$ruta = $url_base . $array_emisor['ruc'] . "/CPE/XML/"  . $nombre_archivo;
	$ruta_cdr = $url_base . $array_emisor['ruc'] . "/CDR/XML/";
	$ruta_firma = $url_base . $array_emisor['ruc'] . "/CPE/FIRMAXML/FIRMAXML.pfx";
	$pass_firma = $data['emisor']['CLAVE_FIRMA'];
	$ruta_ws = 'https://e-factura.sunat.gob.pe/ol-ti-itcpfegem/billService';
}

if ($tipodeproceso == "1") {
	$ruta = $url_base . $array_emisor['ruc'] . "/CPE/BETA/"  . $nombre_archivo;
	$ruta_cdr = $url_base . $array_emisor['ruc'] . "/CDR/BETA/";
	$ruta_firma = "../archivos_xml_sunat/certificados/beta/firmabeta.pfx";
	$pass_firma = '123456';
	$ruta_ws = 'https://e-beta.sunat.gob.pe:443/ol-ti-itcpfegem-beta/billService';
}

$rutas = array();
$rutas['nombre_archivo'] = $nombre_archivo;
$rutas['ruta_xml'] = $ruta;
$rutas['ruta_cdr'] = $ruta_cdr;
$rutas['ruta_firma'] = $ruta_firma;
$rutas['pass_firma'] = $pass_firma;
$rutas['ruta_ws'] = $ruta_ws;

$procesarcomprobante = new Procesarcomprobante();
$resp = $procesarcomprobante->procesar_factura($array_cabecera, $array_detalle, $rutas);
$resp['ruta_xml'] = 'archivos_xml_sunat/cpe_xml/beta/20100066603/' . $nombre_archivo . '.XML';
$resp['ruta_cdr'] = 'archivos_xml_sunat/cpe_xml/beta/20100066603/R-' . $nombre_archivo . '.XML';
$resp['ruta_pdf'] = 'controllers/prueba.php?tipo=factura&id=0';
$resp['ruta_xml'] = "";
$resp['url_xml'] = "";
$resp['ruta_cdr'] = "";
echo json_encode($resp);
exit();

function get_array_cabecera($data, $emisor)
{
	$cabecera['DESCUENTO_GLOBAL'] = (isset($data['discountGlobal']['TOTAL_DESCUENTO'])) ? $data['discountGlobal']['TOTAL_DESCUENTO'] : "0.00";
	$cabecera['PORC_DESCUENTO_GLOBAL'] = (isset($data['discountGlobal']['PORCENTAJE_DESCUENTO'])) ? $data['discountGlobal']['PORCENTAJE_DESCUENTO'] : "0.00";

	$cabecera['EMISOR_RUC'] = $data['header']['NRO_DOCUMENTO_EMPRESA'];
	$cabecera['EMISOR_USUARIO_SOL'] = $data['emisor']['USUARIO_SOL'];
	$cabecera['EMISOR_PASS_SOL'] = $data['emisor']['CLAVE_SOL'];


	$cabecera['TOTAL_BRUTO'] = $data['header']['TOTAL_BRUTO'];
	$cabecera['TIPO_OPERACION'] = $data['header']['TIPO_OPERACION'];
	$cabecera['TOTAL_GRAVADAS'] = (isset($data['header']['TOTAL_GRAVADAS'])) ? $data['header']['TOTAL_GRAVADAS'] : "0";
	$cabecera['TOTAL_INAFECTA'] = (isset($data['header']['TOTAL_INAFECTA'])) ? $data['header']['TOTAL_INAFECTA'] : "0";
	$cabecera['TOTAL_EXONERADAS'] = (isset($data['header']['TOTAL_EXONERADAS'])) ? $data['header']['TOTAL_EXONERADAS'] : "0";
	$cabecera['TOTAL_GRATUITAS'] = $data['header']['TOTAL_GRATUITAS'];
	$cabecera['TOTAL_IGV_GRATUITAS'] = $data['header']['TOTAL_IGV_GRATUITAS'];
	$cabecera['TOTAL_EXPORTACION'] = $data['header']['TOTAL_EXPORTACION'];
	$cabecera['TOTAL_ICBPER'] = (isset($data['header']['TOTAL_ICBPER'])) ? $data['header']['TOTAL_ICBPER'] : 0;
	$cabecera['SUB_TOTAL'] = $cabecera['TOTAL_GRAVADAS'] + $cabecera['TOTAL_INAFECTA'] + $cabecera['TOTAL_EXONERADAS'];
	//$cabecera['SUB_TOTAL'] = (isset($data['header']['TOTAL_GRAVADAS'])) ? $data['header']['TOTAL_GRAVADAS'] : "0";
	//$cabecera['POR_IGV'] = $data['header']['POR_IGV'];
	$cabecera['TOTAL_IGV'] = (isset($data['header']['TOTAL_IGV'])) ? $data['header']['TOTAL_IGV'] : "0";
	$cabecera['TOTAL_ISC'] = $data['header']['TOTAL_ISC'];
	$cabecera['TOTAL_OTR_IMP'] = $data['header']['TOTAL_OTR_IMP'];
	$cabecera['TOTAL'] = (isset($data['header']['TOTAL'])) ? $data['header']['TOTAL'] : "0";
	$cabecera['TOTAL_LETRAS'] = $data['header']['TOTAL_LETRAS'];
	$cabecera['NRO_GUIA_REMISION'] = $data['header']['NRO_GUIA_REMISION'];
	$cabecera['COD_GUIA_REMISION'] = $data['header']['COD_GUIA_REMISION'];
	$cabecera['NRO_OTR_COMPROBANTE'] = $data['header']['NRO_OTR_COMPROBANTE'];
	$cabecera['NRO_COMPROBANTE'] = $data['header']['NRO_COMPROBANTE'];
	$cabecera['FECHA_DOCUMENTO'] = $data['header']['FECHA_DOCUMENTO'];
	$cabecera['FECHA_VTO'] = $data['header']['FECHA_VTO'];
	$cabecera['COD_TIPO_DOCUMENTO'] = $data['header']['COD_TIPO_DOCUMENTO'];
	$cabecera['COD_MONEDA'] = $data['header']['COD_MONEDA'];
	$cabecera['NRO_DOCUMENTO_CLIENTE'] = $data['header']['NRO_DOCUMENTO_CLIENTE'];
	$cabecera['RAZON_SOCIAL_CLIENTE'] = $data['header']['RAZON_SOCIAL_CLIENTE'];
	$cabecera['TIPO_DOCUMENTO_CLIENTE'] = $data['header']['TIPO_DOCUMENTO_CLIENTE'];
	$cabecera['DIRECCION_CLIENTE'] = $data['header']['DIRECCION_CLIENTE'];
	$cabecera['COD_PAIS_CLIENTE'] = $data['header']['COD_PAIS_CLIENTE'];
	$cabecera['COD_UBIGEO_CLIENTE'] = $data['header']['COD_UBIGEO_CLIENTE'];
	$cabecera['DEPARTAMENTO_CLIENTE'] = $data['header']['DEPARTAMENTO_CLIENTE'];
	$cabecera['PROVINCIA_CLIENTE'] = $data['header']['PROVINCIA_CLIENTE'];
	$cabecera['DISTRITO_CLIENTE'] = $data['header']['DISTRITO_CLIENTE'];
	$cabecera['CIUDAD_CLIENTE'] = $data['header']['CIUDAD_CLIENTE'];
	$cabecera['NRO_DOCUMENTO_EMPRESA'] = $data['header']['NRO_DOCUMENTO_EMPRESA'];
	$cabecera['TIPO_DOCUMENTO_EMPRESA'] = $data['header']['TIPO_DOCUMENTO_EMPRESA'];
	$cabecera['NOMBRE_COMERCIAL_EMPRESA'] = $data['header']['RAZON_SOCIAL_EMPRESA'];
	$cabecera['CODIGO_UBIGEO_EMPRESA'] = $data['header']['CODIGO_UBIGEO_EMPRESA'];
	$cabecera['DIRECCION_EMPRESA'] = $data['header']['DIRECCION_EMPRESA'];
	$cabecera['DEPARTAMENTO_EMPRESA'] = $data['header']['DEPARTAMENTO_EMPRESA'];
	$cabecera['PROVINCIA_EMPRESA'] = $data['header']['PROVINCIA_EMPRESA'];
	$cabecera['DISTRITO_EMPRESA'] = $data['header']['DISTRITO_EMPRESA'];
	$cabecera['CODIGO_PAIS_EMPRESA'] = $data['header']['CODIGO_PAIS_EMPRESA'];
	$cabecera['RAZON_SOCIAL_EMPRESA'] = $data['header']['RAZON_SOCIAL_EMPRESA'];
	$cabecera['CONTACTO_EMPRESA'] = $data['header']['CONTACTO_EMPRESA'];
	$cabecera['CODIGO_LOCAL'] = $data['header']['CODIGO_LOCAL'];
	$cabecera['EMISOR_RUC'] = $data['header']['NRO_DOCUMENTO_EMPRESA'];
	$cabecera['FORMA_PAGO'] = $data['header']['FORMA_PAGO'];

	//CAMPO PARA VERIFICAR SI DETRACCION DEBE ESTAR HABILITADA O NO.
	$cabecera['DETRACTION_FLAG'] = $data['header']['DETRACTION_FLAG'];

	if ($data['header']['DETRACTION_FLAG'] == 1) {

		$cabecera['BANK_ACCOUNT_NUMBER'] = $data['header']['BANK_ACCOUNT_NUMBER'];
		$cabecera['PAYMENT_METHOD'] = $data['header']['PAYMENT_METHOD'];
		$cabecera['TYPE_OF_OPERATION'] = $data['header']['TYPE_OF_OPERATION'];
		$cabecera['DETRACTION_TYPE'] = $data['header']['DETRACTION_TYPE'];
		$cabecera['PERCENTAGE_OF_DETRACTION'] = $data['header']['PERCENTAGE_OF_DETRACTION'];
		$cabecera['TOTAL_OF_DETRACTION'] = $data['header']['TOTAL_OF_DETRACTION'];

		if ($data['header']['TYPE_OF_OPERATION'] == 1002) {

			$cabecera['MATRICULA_EMBARCACION'] = $data['header']['MATRICULA_EMBARCACION'];
			$cabecera['NOMBRE_EMBARCACION'] = $data['header']['NOMBRE_EMBARCACION'];
			$cabecera['LUGAR_DESCARGA'] = $data['header']['LUGAR_DESCARGA'];
			$cabecera['CANTIDAD_ESPECIE_VENDIDA'] = $data['header']['CANTIDAD_ESPECIE_VENDIDA'];
			$cabecera['FECHA_DESCARGA'] = $data['header']['FECHA_DESCARGA'];
			$cabecera['DESCRIPCION_TIPO_ESPECIE_VENDIDA'] = $data['header']['DESCRIPCION_TIPO_ESPECIE_VENDIDA'];
		}

		if ($data['header']['TYPE_OF_OPERATION'] == 1004) {

			$cabecera['DIRECCION_ORIGEN'] = $data['header']['DIRECCION_ORIGEN'];
			$cabecera['UBIGEO_ORIGEN'] = $data['header']['UBIGEO_ORIGEN'];
			$cabecera['DIRECCION_DESTINO'] = $data['header']['DIRECCION_DESTINO'];
			$cabecera['UBIGEO_DESTINO'] = $data['header']['UBIGEO_DESTINO'];
			$cabecera['DETALLES_VIAJE'] = $data['header']['DETALLES_VIAJE'];
			$cabecera['VALOR_REFERENCIAL_SERVICIO_TRANSPORTE'] = $data['header']['VALOR_REFERENCIAL_SERVICIO_TRANSPORTE'];
			$cabecera['VALOR_REFERENCIAL_CARGA_EFECTIVA'] = $data['header']['VALOR_REFERENCIAL_CARGA_EFECTIVA'];
			$cabecera['VALOR_REFERENCIAL_CARGA_UTIL'] = $data['header']['VALOR_REFERENCIAL_CARGA_UTIL'];
			$cabecera['UBIGEO_ORIGEN_VIAJE'] = $data['header']['UBIGEO_ORIGEN_VIAJE'];
			$cabecera['UBIGEO_DESTINO_VIAJE'] = $data['header']['UBIGEO_DESTINO_VIAJE'];
			$cabecera['DESCRIPCION_VIAJE'] = $data['header']['DESCRIPCION_VIAJE'];
			$cabecera['VALOR_REFERENCIAL_CARGA_EFECTIVA_TRAMO_VIRTUAL'] = $data['header']['VALOR_REFERENCIAL_CARGA_EFECTIVA_TRAMO_VIRTUAL'];
			$cabecera['CONFIGURACION_VEHICULAR'] = $data['header']['CONFIGURACION_VEHICULAR'];
			$cabecera['CARGA_UTIL_TONELADAS_METRICAS'] = $data['header']['CARGA_UTIL_TONELADAS_METRICAS'];
			$cabecera['CARGA_EFECTIVA_TONELADAS_METRICAS'] = $data['header']['CARGA_EFECTIVA_TONELADAS_METRICAS'];
			$cabecera['VALOR_PRELIMINAR_POR_CARGA_UTIL_NOMINAL'] = $data['header']['VALOR_PRELIMINAR_POR_CARGA_UTIL_NOMINAL'];
			$cabecera['VALOR_REFERENCIAL_POR_TONELADA_METRICAS'] = $data['header']['VALOR_REFERENCIAL_POR_TONELADA_METRICAS'];
			$cabecera['FACTOR_RETORNO_VACIO'] = $data['header']['FACTOR_RETORNO_VACIO'];
		}
	}






	if (isset($data['header']['FORMA_PAGO_CUOTAS'])) {
		$cabecera['FORMA_PAGO_CUOTAS'] = $data['header']['FORMA_PAGO_CUOTAS'];
	}

	//*************************************START TRJ143 - DANIEL PADILLA- 23/12/2022 **************************
	if (isset($data['header']['RETAINER_TOTAL']) && $data['header']['RETAINER_TOTAL'] > 0) {
		$cabecera['RETAINER_TOTAL'] = $data['header']['RETAINER_TOTAL'];
		$cabecera['RETAINER_PERCENTAGE'] = $data['header']['RETAINER_PERCENTAGE'];
	}
	//*************************************END TRJ143 - DANIEL PADILLA- 23/12/2022 **************************


	return $cabecera;
}

function get_array_detalle($data)
{

	/* la estructura del array con los items debe tener la siguiente estructura!
		"detalle" => [
                    {
                        "txtITEM"          			=> 1,
                        "txtUNIDAD_MEDIDA_DET"      => "NIU",
                        "txtCANTIDAD_DET"           => "1",
                        "txtPRECIO_DET"             => "100",
                        "txtSUB_TOTAL_DET"          => "84.75",
                        "txtPRECIO_TIPO_CODIGO"     => "01",
                        "txtIGV"                 	=> "15.25",
                        "txtISC"                  	=> "0",
                        "txtIMPORTE_DET"            => "84.75",
                        "txtCOD_TIPO_OPERACION"     => "10",
                        "txtCODIGO_DET"             => "DSDFG",
                        "txtDESCRIPCION_DET"   		=> "Producto 01",
                        "txtPRECIO_SIN_IGV_DET"  	=> 84.75
					}
				]
		*/

	$posicion = 1;

	for ($colum = 0; $colum < count($data["item"]); $colum++) {
		$detalle_documento[$colum]["txtITEM"] = $posicion;
		$detalle_documento[$colum]["txtUNIDAD_MEDIDA_DET"] = $data["item"][$posicion]['txtUNIDAD_MEDIDA_DET'];
		$detalle_documento[$colum]["txtCANTIDAD_DET"] = $data["item"][$posicion]['txtCANTIDAD_DET'];
		$detalle_documento[$colum]["txtIMPORTE_DET"] = $data["item"][$posicion]['txtIMPORTE_DET'];
		$detalle_documento[$colum]["txtPRECIO_DET"] = $data["item"][$posicion]['txtPRECIO_DET'];
		$detalle_documento[$colum]["txtPRECIO_TIPO_CODIGO"] = $data["item"][$posicion]['txtPRECIO_TIPO_CODIGO'];
		$detalle_documento[$colum]["txtIGV"] = $data["item"][$posicion]['txtIGV'];
		$detalle_documento[$colum]["ICBPER_DET"] = $data["item"][$posicion]['ICBPER_DET'];
		//$detalle_documento[$colum]["txtCOD_TIPO_OPERACION"] = $data["item"][$posicion]['txtCOD_TIPO_OPERACION'] ;
		$detalle_documento[$colum]["txtDESCRIPCION_DET"] = $data["item"][$posicion]['txtDESCRIPCION_DET'];
		$detalle_documento[$colum]["txtCODIGO_DET"] = $data["item"][$posicion]['txtCODIGO_DET'];
		$detalle_documento[$colum]['txtCODIGO_PROD_SUNAT'] = $data["item"][$posicion]['txtCODIGO_PROD_SUNAT'];
		$detalle_documento[$colum]["txtPRECIO_SIN_IGV_DET"] = $data["item"][$posicion]['txtPRECIO_SIN_IGV_DET'];
		$detalle_documento[$colum]["CODIGO_IMPUESTO"] = $data["item"][$posicion]['CODIGO_IMPUESTO'];
		$detalle_documento[$colum]["TIPO_IMPUESTO"] = $data["item"][$posicion]['TIPO_IMPUESTO'];
		$detalle_documento[$colum]["TIPO_CODIGO_IMPUESTO"] = $data["item"][$posicion]['TIPO_CODIGO_IMPUESTO'];
		$detalle_documento[$colum]["CODIGO_CATEGORIA_IMPUESTO"] = $data["item"][$posicion]['CODIGO_CATEGORIA_IMPUESTO'];
		$detalle_documento[$colum]["CODIGO_EXTENSION_IMPUESTO"] = $data["item"][$posicion]['CODIGO_EXTENSION_IMPUESTO'];
		$detalle_documento[$colum]["IGV_ITEM"] = $data["item"][$posicion]['IGV_ITEM'];


		$posicion++;
	}


	return $detalle_documento;
}

function get_array_emisor($data)
{

	//si estamos ofreciendo un servicio de facturación electrónica, aquí podemos recibir el ruc, y el resto de datos podemos extraerlos desde nuestra base de datos.
	//en este caso, asumimos que todos los datos llegan desde la petición.

	$emisor['usuariosol'] 				= $data['emisor']['USUARIO_SOL'];
	$emisor['clavesol'] 				= $data['emisor']['CLAVE_SOL'];
	$emisor['tipo_proceso'] 			= $data['emisor']['BETA'];

	$emisor['ruc'] 						= $data['header']['NRO_DOCUMENTO_EMPRESA'];
	$emisor['tipo_doc'] 				= $data['header']['TIPO_DOCUMENTO_EMPRESA'];
	$emisor['nom_comercial'] 			= $data['header']['RAZON_SOCIAL_EMPRESA'];
	$emisor['razon_social'] 			= $data['header']['RAZON_SOCIAL_EMPRESA'];
	$emisor['codigo_ubigeo'] 			= '';
	$emisor['direccion'] 				= '';
	$emisor['direccion_departamento'] 	= '';
	$emisor['direccion_provincia'] 		= '';
	$emisor['direccion_distrito'] 		= '';
	$emisor['direccion_codigopais'] 	= '';

	//Todos los campos anteriores son obligatorios
	//Aquí se pueden generar todas las validaciones que se necesiten.
	//por ejemplo: si ruc está vacio, retornar un error

	return $emisor;
}
