<?php
	ini_set('display_errors', 1);
	ini_set('display_startup_errors', 1);
	error_reporting(E_ALL);
	include "../controllers/validaciondedatos.php";
	include "../controllers/procesarcomprobante.php";

	error_reporting(E_ALL ^ E_NOTICE);
	// para aceptar la conexión desde cualquier origen
	header("Access-Control-Allow-Origin: *");

	// Permite los métodos GET, POST, PUT, DELETE
	header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
	//exit(); 
	//obtenemos la data de la solicitud
	$bodyRequest = file_get_contents("php://input");

	// Decodificamos y lo guardamos en un array
	$data = json_decode($bodyRequest, true);

	$array_emisor = get_array_emisor($data);
	$array_detalle = get_array_detalle($data);
	$array_cabecera = get_array_cabecera($data, $array_emisor);
	$tipodeproceso = (isset($data['header']['tipo_proceso'])) ? $data['header']['tipo_proceso'] : "1";

	$url_base = '../archivos_xml_sunat/FE/';
    
	
	$nombre_archivo = $array_emisor['ruc'] . '-' . $data['header']['cod_tipo_documento'] . '-' . $data['header']['SERIE_SECUENCIA'];

	if ($tipodeproceso == '0') {
        //$ruta = $url_base . $content_folder_xml . 'produccion/' . $array_emisor['ruc'] . "/" . $nombre_archivo;
        //$ruta_cdr = $url_base . $content_folder_xml . 'produccion/' . $array_emisor['ruc'] . "/";
        //$ruta_firma = $url_base . $content_firmas . 'produccion/' . $array_emisor['ruc'] . '.pfx';
		$ruta = $url_base . $array_emisor['ruc'] . "/CPE/XML/"  . $nombre_archivo;
        $ruta_cdr = $url_base . $array_emisor['ruc'] . "/CDR/XML/";
        $ruta_firma = $url_base . $array_emisor['ruc'] . "/CPE/FIRMAXML/FIRMAXML.pfx";
		$pass_firma = $data['header']['CLAVE_FIRMA'];
        $ruta_ws = 'https://e-guiaremision.sunat.gob.pe/ol-ti-itemision-guia-gem/billService';
	}
	
    if ($tipodeproceso == '1') {
		//$ruta = $url_base . $content_folder_xml . 'beta/' . $array_emisor['ruc'] . "/" . $nombre_archivo;
        //$ruta_cdr = $url_base . $content_folder_xml . 'beta/' . $array_emisor['ruc'] . "/";
        //$ruta_firma = $url_base . $content_firmas.'beta/firmabeta.pfx';
		$ruta = $url_base . $array_emisor['ruc'] . "/CPE/BETA/"  . $nombre_archivo;
        $ruta_cdr = $url_base . $array_emisor['ruc'] . "/CDR/BETA/";
        $ruta_firma = "../archivos_xml_sunat/certificados/beta/firmabeta.pfx";
        $pass_firma = '123456';
        $ruta_ws = 'https://e-beta.sunat.gob.pe/ol-ti-itemision-guia-gem-beta/billService';
	}

	$rutas = array();
    $rutas['nombre_archivo'] = $nombre_archivo;
    $rutas['ruta_xml'] = $ruta;
    $rutas['ruta_cdr'] = $ruta_cdr;
    $rutas['ruta_firma'] = $ruta_firma;
    $rutas['pass_firma'] = $pass_firma;
	$rutas['ruta_ws'] = $ruta_ws;
	
	$procesarcomprobante = new Procesarcomprobante();
	$resp = $procesarcomprobante->procesar_guia_de_remision($array_cabecera, $array_detalle, $rutas);
	$resp['ruta_xml'] = 'archivos_xml_sunat/cpe_xml/beta/20100066603/'.$nombre_archivo.'.XML';
	$resp['ruta_cdr'] = 'archivos_xml_sunat/cpe_xml/beta/20100066603/R-'.$nombre_archivo.'.XML';
	$resp['ruta_pdf'] = 'controllers/prueba.php?tipo=factura&id=0';
	$resp['ruta_xml'] = "";
	$resp['url_xml'] = "";
	$resp['ruta_cdr'] = "";
	echo json_encode($resp);
	exit();
	
	function get_array_cabecera($data, $emisor) {
		$cabecera = array(
			'SERIE_SECUENCIA' => $data['header']['SERIE_SECUENCIA'],
			/*'SERIE' => $data['serie_comprobante'],
			'SECUENCIA' => $data['numero_comprobante'],*/
			'FECHA_DOCUMENTO' => $data['header']['FECHA_DOCUMENTO'],
			'CODIGO' => $data['header']['cod_tipo_documento'],
			'NOTA' => $data['header']['nota'],
			//01 VENTA, 14 VENTA SUJETA A CONFIRMACION DEL COMPRADOR, 02 COMPRA
			//04 TRASLADO ENTRE ESTABLECIMIENTOS DE LA MISMA EMPRESA, 18 TRASLADO EMISOR ITINERANTE CP
			//08 IMPORTACION, 09 EXPORTACION, 19 TRASLADO A ZONA PRIMARIA, 13 OTROS
			'CODMOTIVO_TRASLADO' => $data['header']['CODMOTIVO_TRASLADO'],
			'MOTIVO_TRASLADO' => $data['header']['motivo_traslado'],
			'PESO'	=> $data['header']['peso'],
			'unidad_medida'	=> $data['header']['unidad_medida'],
			'NUMERO_PAQUETES' => $data['header']['NUMERO_PAQUETES'],
			'CODTIPO_TRANSPORTISTA' => $data['header']['codtipo_transportista'], //01 Transporte público, 02 Transporte privado
			'TIPO_DOCUMENTO_TRANSPORTE' => $data['header']['tipo_documento_transporte'], //6: indica RUC: Catálogo 06
			'NRO_DOCUMENTO_TRANSPORTE' => $data['header']['nro_documento_transporte'],
			'RAZON_SOCIAL_TRANSPORTE' => $data['header']['razon_social_transporte'],
			//'PLACA' => $data['header']['PLACA'],
			'FECHA_INICIO_TRASLADO' => $data['header']['FECHA_INICIO_TRASLADO'],
			'UBIGEO_DESTINO' => $data['header']['ubigeo_destino'],
			'DIR_DESTINO' => $data['header']['dir_destino'],
			'UBIGEO_PARTIDA' => $data['header']['ubigeo_partida'],
			'DIR_PARTIDA' => $data['header']['dir_partida'],
			
	        //==================================================
	        'NRO_DOCUMENTO_CLIENTE' => $data['header']['cliente_numerodocumento'],
			'RAZON_SOCIAL_CLIENTE' => $data['header']['cliente_nombre'],
			'TIPO_DOCUMENTO_CLIENTE' => $data['header']['cliente_tipodocumento'],
	        //===============================================
			'NRO_DOCUMENTO_EMPRESA' => $emisor['ruc'],
			'TIPO_DOCUMENTO_EMPRESA' => $emisor['tipo_doc'], //RUC
			'NOMBRE_COMERCIAL_EMPRESA' => $emisor['nom_comercial'],
			'CODIGO_UBIGEO_EMPRESA' => $emisor['codigo_ubigeo'],
	        'DIRECCION_EMPRESA' => $emisor['direccion'],
	        'DEPARTAMENTO_EMPRESA' => $emisor['direccion_departamento'],
	        'PROVINCIA_EMPRESA' => $emisor['direccion_provincia'],
	        'DISTRITO_EMPRESA' => $emisor['direccion_distrito'],
			'CODIGO_PAIS_EMPRESA' => $emisor['direccion_codigopais'],
			'RAZON_SOCIAL_EMPRESA' => $emisor['razon_social'],
			'CONTACTO_EMPRESA' => "",
	        //===================CLAVES SOL EMISOR====================//
	        'EMISOR_RUC' => $emisor['ruc'],
	        'EMISOR_USUARIO_SOL' => $emisor['usuariosol'],
			'EMISOR_PASS_SOL' => $emisor['clavesol']
		);
		
		return $cabecera;
	}

	function get_array_detalle($data) {

		/* la estructura del array con los items debe tener la siguiente estructura!
		"detalle" => [
                    {
                        "txtITEM"          			=> 1,
                        "txtUNIDAD_MEDIDA_DET"      => "NIU",
                        "txtCANTIDAD_DET"           => "1",
                        "txtPRECIO_DET"             => "100",
                        "txtSUB_TOTAL_DET"          => "84.75",
                        "txtPRECIO_TIPO_CODIGO"     => "01",
                        "txtIGV"                 	=> "15.25",
                        "txtISC"                  	=> "0",
                        "txtIMPORTE_DET"            => "84.75",
                        "txtCOD_TIPO_OPERACION"     => "10",
                        "txtCODIGO_DET"             => "DSDFG",
                        "txtDESCRIPCION_DET"   		=> "Producto 01",
                        "txtPRECIO_SIN_IGV_DET"  	=> 84.75
					}
				]
		*/
		$posicion=1;
		
		for($colum=0; $colum<count($data["item"]); $colum++){
			$detalle_documento[$colum]["ITEM"] = $posicion;
			$detalle_documento[$colum]["NUMERO_ORDEN"] = $data["item"][$posicion]['NUMERO_ORDEN'] ;
			$detalle_documento[$colum]["CODIGO_PRODUCTO"] = $data["item"][$posicion]['CODIGO_PRODUCTO'] ;
			$detalle_documento[$colum]["DESCRIPCION"] = $data["item"][$posicion]['DESCRIPCION'] ;
			$detalle_documento[$colum]["PESO"] = $data["item"][$posicion]['PESO'] ;
			$detalle_documento[$colum]["CODE_UNIDAD_MEDIDA"] = $data["item"][$posicion]['CODE_UNIDAD_MEDIDA'] ;
			
			$posicion++;
		}
		
		
		return $detalle_documento;
	}

	function get_array_emisor($data) {
		//$data_emisor = $data['emisor'];

		//si estamos ofreciendo un servicio de facturación electrónica, aquí podemos recibir el ruc, y el resto de datos podemos extraerlos desde nuestra base de datos.
		//en este caso, asumimos que todos los datos llegan desde la petición.

		$emisor['ruc'] 						= $data['header']['ruc'];
		$emisor['tipo_doc'] 				= $data['header']['tipo_doc_empresa'];
		$emisor['nom_comercial'] 			= $data['header']['razon_social_empresa'];
		$emisor['razon_social'] 			= $data['header']['razon_social_empresa'];
		$emisor['codigo_ubigeo'] 			= $data['header']['codigo_ubigeo'];
		$emisor['direccion'] 				= $data['header']['direccion'];
		$emisor['direccion_departamento'] 	= $data['header']['direccion_departamento'];
		$emisor['direccion_provincia'] 		= $data['header']['direccion_provincia'];
		$emisor['direccion_distrito'] 		= $data['header']['direccion_distrito'];
		$emisor['direccion_codigopais'] 	= $data['header']['direccion_codigopais'];
		$emisor['usuariosol'] 				= $data['header']['usuariosol'];
		$emisor['clavesol'] 				= $data['header']['clavesol'];

		//Todos los campos anteriores son obligatorios
		//Aquí se pueden generar todas las validaciones que se necesiten.
		//por ejemplo: si ruc está vacio, retornar un error

		return $emisor;
	}
?>