<?php

namespace App\Controllers;

use Psr\Http\Message\ServerRequestInterface as Request;
use Psr\Http\Message\ResponseInterface as Response;
use App\Models\MySQL\CodeyGenerateCustomer\CustomerModel;
use App\DAO\MySQL\CodeBD\CustomerDAO;
use App\DAO\MySQL\CodeBD\UserDAO;
use App\DAO\MySQL\CodeBD\LocalDAO;
use App\DAO\MySQL\CodeBD\CanalDAO;
use App\DAO\MySQL\CodeBD\WarehouseDAO;

final class CustomerController
{
	public function register_customer(Request $request, Response $response, array $args): Response
	{
		$data_recibida = $request->getParsedBody();
		
		$datos_empresa_general = $this->conexionBDgeneral($data_recibida['empresa']['ruc']);
		
		$customer_query = new CustomerDAO();
		
		//$valid_nDocument_ruc=0;
		if(strlen(trim($data_recibida['customer']['Customers_type']))>0){
			if(is_numeric(trim($data_recibida['customer']['Customers_type']))){
				$datos_customer = $customer_query->valid_tipo_cliente
				(trim($data_recibida['customer']['Customers_type']), $datos_empresa_general);
				$captura_tip_cliente = count($datos_customer);
				if($captura_tip_cliente > 0){
				}else{
					$mensaje['mensaje'][]="error con el tipo de cliente";
				}
			}else{
				$mensaje['mensaje'][]="error con el tipo de cliente";
			}
		}else{
			$data_recibida['customer']['Customers_type']="0";
		}
		
		if(strlen(trim($data_recibida['customer']['name']))>0){}else{
			$mensaje['mensaje'][]="error con el nombre del cliente";
		}
		
		if(strlen(trim($data_recibida['customer']['Phone']))>0){
			if(is_numeric(trim($data_recibida['customer']['Phone']))){}else{
				$mensaje['mensaje'][]="error con el formato del telefono del cliente";
			}
		}
		
		if(strlen(trim($data_recibida['customer']['Email']))>0){
			/*$valid_Email=strpos($data_recibida['customer']['Email'],'@');
			if(is_numeric($valid_Email)){}else{
				$mensaje['mensaje'][]="error con el formato del correo del cliente";
			}*/
			if (filter_var(trim($data_recibida['customer']['Email']), FILTER_VALIDATE_EMAIL)){}else{
				$mensaje['mensaje'][]="error con el formato del correo del cliente";
			}
		}
		
		if(is_numeric(trim($data_recibida['customer']['Document_type']))){
			$datos_document = $customer_query->valid_tipo_documento
			(trim($data_recibida['customer']['Document_type']), $datos_empresa_general);
			$captura_tip_doc = count($datos_document);
			if($captura_tip_doc > 0){
				$sensor_tip_doc=1;
			}else{
				$mensaje['mensaje'][]="error con el tipo de documento";
			}
		}else{
			$mensaje['mensaje'][]="error con el tipo de documento";
		}
		
		if(trim($data_recibida['customer']['Person_type'])=="1" || trim($data_recibida['customer']['Person_type'])=="2"){
			if(isset($sensor_tip_doc)){
				if(trim($data_recibida['customer']['Person_type'])=="2"){
					if(trim($data_recibida['customer']['Document_type'])=="6"){
						$sensor_tip_persona=2;
					}else{
						$mensaje['mensaje'][]="el documento debe ser ruc cuando es persona juridica";
					}
				}else{
					if(trim($data_recibida['customer']['Document_type'])=="6"){
						$mensaje['mensaje'][]="el documento no puede ser ruc cuando es persona natural";
					}else{
						$sensor_tip_persona=1;
					}
				}
			}
		}else{
			$mensaje['mensaje'][]="error con el tipo de persona";
		}
		
		if(isset($sensor_tip_persona) && isset($sensor_tip_doc)){
			
			if(trim($data_recibida['customer']['Person_type'])=="2"){
				if(strlen(trim($data_recibida['customer']['ruc']))==11){
						$valid_number_docum=1;
						$valid_ruc=1;
					}else{
						$mensaje['mensaje'][]="cuando el numero del documento es ruc debe ser de 11 digitos";
				}
			}else{
				
					if(strlen(trim($data_recibida['customer']['document_numeric']))>0){
					//$valid_nDocument_ruc++;
						if(trim($data_recibida['customer']['Document_type'])=="1"){
							if(strlen(trim($data_recibida['customer']['document_numeric']))==8){
								if(is_numeric(trim($data_recibida['customer']['document_numeric']))){
									$valid_number_docum=1;
								}else{
									$mensaje['mensaje'][]="cuando el numero del documento es dni debe ser numerico";
								}
							}else{
								$mensaje['mensaje'][]="cuando el numero del documento es dni debe ser de 8 digitos";
							}
						}
					
					}else{
						//$mensaje['mensaje'][]="error de formato con el documento de identificación";
						//$data_recibida['customer']['Document_type']="6";
						$data_recibida['customer']['document_numeric']="--";
					}
				
				if(strlen(trim($data_recibida['customer']['ruc']))>0){
					//$valid_nDocument_ruc++;
					if(strlen(trim($data_recibida['customer']['ruc']))==11){
						$valid_number_docum=1;
						//$valid_ruc=1;
					}else{
						$mensaje['mensaje'][]="cuando el numero del documento es ruc debe ser de 11 digitos";
					}
				}
				
				/*if($valid_nDocument_ruc>0){}else{
					//$mensaje['mensaje'][]="se debe ingresar un ruc o el número de documento especificado";
				}*/
				
			}
				
		}
		
		
				
		
		if(isset($valid_ruc)){
			if(strlen(trim($data_recibida['customer']['address']))>0){}else{
				$mensaje['mensaje'][]="error con la direccion del cliente";
			}
		}
		
			if(strlen(trim($data_recibida['customer']['document_numeric']))>0 && trim($data_recibida['customer']['document_numeric'])!="--"){
				if(trim($data_recibida['customer']['Document_type'])=="1"){
					$datos_customer_valid = $customer_query->valid_Customer
					(trim($data_recibida['customer']['document_numeric']), 
					trim($data_recibida['empresa']['ruc']), 
					$datos_empresa_general);
					
					$captura_customer_valid = count($datos_customer_valid);
					if($captura_customer_valid>0){
						$mensaje['mensaje'][]="el numero de documento ya fue registrado anteriormente";
					}
				}				
			}
			
			if(strlen(trim($data_recibida['customer']['ruc']))>0){
				$datos_customer_validRuc = $customer_query->valid_Customer
				(trim($data_recibida['customer']['ruc']), 
				trim($data_recibida['empresa']['ruc']), 
				$datos_empresa_general);
					
				$captura_customer_ruc = count($datos_customer_validRuc);
				if($captura_customer_ruc>0){
					$mensaje['mensaje'][]="el ruc del cliente ya fue registrado anteriormente";
				}
			}
		
		
		if(isset($mensaje)){
			$mensaje['resultado']="error";
		}else{
			
			$customer = new CustomerModel();
			$customer->setName(trim($data_recibida['customer']['name']));
			$customer->setDireccion(trim($data_recibida['customer']['address']));
			$customer->setPhone(trim($data_recibida['customer']['Phone']));
			$customer->setEmail(trim($data_recibida['customer']['Email']));
			$customer->setCustomers_type_id(trim($data_recibida['customer']['Customers_type']));
			$customer->setEstado(1);
			
			
			if(trim($data_recibida['customer']['Person_type'])=="2"){
				$customer->setCf2(trim($data_recibida['customer']['ruc']));
				$customer->setCf1("");
			}else{
				$customer->setCf2(trim($data_recibida['customer']['ruc']));
				$customer->setCf1(trim($data_recibida['customer']['document_numeric']));
				/*if(strlen(trim($data_recibida['customer']['ruc']))>0){
					if(trim($data_recibida['customer']['Document_type'])=="1"){
							$data_recibida['customer']['Document_type']="6";
					}
				}*/
			}
			
			$customer->setDocument_type_id(trim($data_recibida['customer']['Document_type']));
			$customer->setPerson_type(trim($data_recibida['customer']['Person_type']));
			
			
			$idCustomerDni = $customer_query->insert_customer
			($customer, 
			trim($data_recibida['empresa']['ruc']), 
			$datos_empresa_general);
			$mensaje['id_customer']=$idCustomerDni[0];
			$mensaje['resultado']="ok";
			
		}
		
		$resp_json = $response->withJson($mensaje);
		return $resp_json;
	}
	
	public function conexionBDgeneral($ruc)
	{

		$postData['ruc'] = $ruc;

		$context = stream_context_create(array(
			'http' => array(
				'method' => 'POST',
				'header' => "Authorization: application/json\r\n" .
					"Content-Type: application/json\r\n",
				'content' => json_encode($postData)
			)
		));

		$url = getenv('WSurl_general');
		$urlDoc = "v1/Empresa/datos";
		$response = file_get_contents($url . $urlDoc, false, $context);
		$res = json_decode($response, true);

		$datosEmp['ruc'] = $res['ruc'];
		$datosEmp['razon_social'] = $res['razon_social'];
		$datosEmp['usuario_sol'] = $res['usuario_sol'];
		$datosEmp['usuario_secundario'] = $res['usuario_secundario'];
		$datosEmp['clave_secundario'] = $res['clave_secundario'];
		$datosEmp['password_firma'] = $res['password_firma'];
		$datosEmp['host_BD'] = $res['host_BD'];

		$datosEmp['BD_sistema'] = $res['BD_sistema'];
		$datosEmp['usuario_BD'] = $res['usuario_BD'];
		$datosEmp['password_BD'] = $res['password_BD'];
		$datosEmp['subdominio'] =$res['subdominio'];


		return $datosEmp;
	}
	
}