<?php

namespace App\DAO\MySQL\CodeBD;

class LocalDAO extends Conexao
{
	
	public function __construct()
	{
		parent::__construct();
	}
	
	public function valid_local($local_id, array $datos_emp): array
	{
		
		try{
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
		
			$statement = $conexion->prepare('CALL `valid_local`(
				:local_id
			);');
			
			$statement->execute([
				'local_id' => $local_id
			]);
			
			$row = $statement->fetchAll(\PDO::FETCH_ASSOC);
			$statement->closeCursor();
			return $row;
			
		}catch(PDOException $e){
			$row[0] =0;
			
			return $row;
		}
		
	}
	
}
