<?php

namespace App\DAO\MySQL\CodeBD;
use App\Models\MySQL\CodeyGenerateNoteCredit\NoteCreditModel;
use App\Models\MySQL\CodeyGenerateNoteCredit\NoteCreditItemsModel;
use App\Models\MySQL\CodeyGenerateNoteCredit\NoteCreditModelSendInvoice;

class NoteCreditDAO extends Conexao
{
	
	public function __construct()
	{
		parent::__construct();
	}
	
	public function regist_NC_db(NoteCreditModel $note_credit, array $note_credit_items, array $datos_emp): array
	{
		$note_credit_item = new NoteCreditItemsModel();
		$id_note_credit= 1;
		$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
		
		try{
		
			$statement = $conexion->prepare('CALL `increment_bill`(
				:sale_id,
				:responseCode,
				:invoiceTypeCode,
				:serieNumero,
				:issueDate,
				:issueTime,
				:documentCurrencyCode,
				:supplierDocumentID,
				:customerDocumentID,
				:customerID,
				:customerName,
				:taxAmount,
				:taxableAmount,			
				:taxSubtotal,
				:payableAmount,
				:referenceID,
				:DocumentTypeCode,
				:description,
				:user_create,
				:date_create,
				:estado,
				:result02,
				@resultado,
				@resultSERIEcorre,
				:non_affected,
				:exonerated
			);');
			
			$statement->execute([
				'sale_id' => $note_credit->getSale_id(),
				'responseCode' => $note_credit->getResponseCode(),
				'invoiceTypeCode' => $note_credit->getInvoiceTypeCode(),
				'serieNumero' => $note_credit->getSerieNumero(),
				'issueDate' => $note_credit->getIssueDate(),
				'issueTime' => $note_credit->getIssueTime(),
				'documentCurrencyCode' => $note_credit->getDocumentCurrencyCode(),
				'supplierDocumentID'=> $note_credit->getSupplierDocumentID(),
				'customerDocumentID' => $note_credit->getCustomerDocumentID(),
				'customerID' => $note_credit->getCustomerID(),
				'customerName' => $note_credit->getCustomerName(),
				'taxAmount' => $note_credit->getTaxAmount(),
				'taxableAmount' => $note_credit->getTaxableAmount(),		
				'taxSubtotal' => $note_credit->getTaxSubtotal(),
				'payableAmount' => $note_credit->getPayableAmount(),
				'referenceID' => $note_credit->getReferenceID(),
				'DocumentTypeCode' => $note_credit->getDocumentTypeCode(),
				'description' => $note_credit->getDescription(),
				'user_create' => $note_credit->getUser_create(),
				'date_create' => $note_credit->getDate_create(),
				'estado' => $note_credit->getEstado(),
				'result02' => 1,
				'non_affected' => $note_credit->getNon_affected(),
				'exonerated' => $note_credit->getExonerated(),	
			]);
			
			$statement->closeCursor();
			$row = $conexion->query("SELECT @resultado AS resultado, @resultSERIEcorre AS resultSERIEcorre")->fetch(\PDO::FETCH_ASSOC);
			$id_note_credit =$row['resultado'];
			$invoice_note_credit[0] =$row['resultSERIEcorre'];
			$invoice_note_credit[1] =$id_note_credit;
			
		}catch(PDOException $e){
			$id_note_credit=0;
		}

		if($invoice_note_credit[1]> 0){
			
				for($contador=1; $contador < count($note_credit_items) + 1; $contador++){
				
					$note_credit_item->setCredit_note_id($id_note_credit);
					$note_credit_item->setQuantity($note_credit_items[$contador]['Quantity']);
					$note_credit_item->setLineExtensionAmount($note_credit_items[$contador]['LineExtensionAmount']);
					$note_credit_item->setPricingReference($note_credit_items[$contador]['PricingReference']);
					$note_credit_item->setPriceTypeCode($note_credit_items[$contador]['PriceTypeCode']);
					$note_credit_item->setTaxTotalTaxAmount($note_credit_items[$contador]['TaxTotalTaxAmount']);
					$note_credit_item->setTaxSubtotalTaxableAmount($note_credit_items[$contador]['TaxSubtotalTaxableAmount']);
					$note_credit_item->setPriceAmount($note_credit_items[$contador]['PriceAmount']);
					$note_credit_item->setTaxSubtotalTaxAmount($note_credit_items[$contador]['TaxSubtotalTaxAmount']);
					$note_credit_item->setTaxPercent($note_credit_items[$contador]['TaxPercent']);
					$note_credit_item->setTax_method($note_credit_items[$contador]['tax_method']);
					$note_credit_item->setDescription($note_credit_items[$contador]['Description']);
					$note_credit_item->setItemSellersID($note_credit_items[$contador]['itemSellersID']);
					$note_credit_item->setUser_create($note_credit->getUser_create());
					$note_credit_item->setDate_create($note_credit->getDate_create());
					$note_credit_item->setEstado($note_credit->getEstado());
					
					$this->regist_NCitems_db($note_credit_item, $datos_emp);
				}
		}
		
        return $invoice_note_credit;//$note_credit_items[2]['TaxTotalTaxAmount']); 
		
	}
	
	public function regist_NCitems_db(NoteCreditItemsModel $note_credit_items, $datos_emp){
		
		$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
		$statement = $conexion->prepare('INSERT INTO  tec_credit_note_items VALUES(
		null,
		:credit_note_id,
		:Quantity,
		:LineExtensionAmount,
		:PricingReference,
		:PriceTypeCode,
		:TaxTotalTaxAmount,
		:TaxSubtotalTaxableAmount,
		:PriceAmount,
		:TaxSubtotalTaxAmount,
		:TaxPercent,
		:tax_method,
		:Description,
		:itemSellersID,
		null,
		null,
		:user_create,
		:date_create,
		:estado
		);');
		
		$statement->execute([
			'credit_note_id' => $note_credit_items->getCredit_note_id(),
			'Quantity' => $note_credit_items->getQuantity(),
			'LineExtensionAmount' => $note_credit_items->getLineExtensionAmount(),
			'PricingReference' => $note_credit_items->getPricingReference(),
			'PriceTypeCode' => $note_credit_items->getPriceTypeCode(),
			'TaxTotalTaxAmount' => $note_credit_items->getTaxTotalTaxAmount(),
			'TaxSubtotalTaxableAmount' => $note_credit_items->getTaxSubtotalTaxableAmount(),
			'PriceAmount' => $note_credit_items->getPriceAmount(),
			'TaxSubtotalTaxAmount' => $note_credit_items->getTaxSubtotalTaxAmount(),
			'TaxPercent' => $note_credit_items->getTaxPercent(),
			'tax_method' => $note_credit_items->getTax_method(),
			'Description' => $note_credit_items->getDescription(),
			'itemSellersID' => $note_credit_items->getItemSellersID(),
			'user_create' => $note_credit_items->getUser_create(),
			'date_create' => $note_credit_items->getDate_create(),
			'estado' => $note_credit_items->getEstado()
		]);
		
		
	}
	
	public function consult_NC_header($id, $datos_emp): array
	{
		$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
		$result = $conexion->query('SELECT 
							responseCode,
							invoiceTypeCode,
							serieNumero,
							issueDate,
							issueTime,
							documentCurrencyCode,
							supplierDocumentID,
							customerDocumentID,
							customerID,
							customerName,
							taxAmount,
							taxableAmount,
							non_affected,
							exonerated,
							taxSubtotal,
							payableAmount,
							referenceID,
							DocumentTypeCode,
							description,
							user_create,
							date_create 
						FROM tec_credit_note 
						WHERE id = '.$id.'
					')->fetchAll(\PDO::FETCH_ASSOC);
		
		return $result;
	}
	
	public function consult_NC_items($id): array
	{
		$conexion = Conexao::conectarBd('127.0.0.1',
							'basketperu_db_11111111132',
							'basketperu_u_11111111132',
							'actecaUWI');
		$result = $conexion->query('SELECT 
							Quantity,
							LineExtensionAmount,
							PricingReference,
							PriceTypeCode,
							TaxTotalTaxAmount,
							TaxSubtotalTaxableAmount,
							PriceAmount,
							TaxSubtotalTaxAmount,
							TaxPercent,
							tax_method,
							Description,
							itemSellersID 
						FROM tec_credit_note_items 
						WHERE credit_note_id = '.$id.'
					')->fetchAll(\PDO::FETCH_ASSOC);
		
		return $result;
	}
	
	public function update_data_XML_db(NoteCreditModel $note_credit, $datos_emp)
	{
		try{
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
			$statement = $conexion->prepare('UPDATE tec_credit_note SET
								flg_response = :flg_response,
								error_code = :error_code,
								response_descrip = :response_descrip,
								digest_value = :digest_value
							WHERE
								id = :id
						');
						
			$statement->execute([
				'flg_response' => $note_credit->getFlg_response(),
				'error_code' => $note_credit->getError_code(),
				'response_descrip' => $note_credit->getResponse_descrip(),
				'digest_value' => $note_credit->getDigest_value(),
				'id' => $note_credit->getId()
			]);
		
		}catch(PDOException $e){
			
		}
			
	}
	
	public function regist_send_invoice_NC(NoteCreditModelSendInvoice $sendInvoice, $datos_emp)
	{
		$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
		$statement = $conexion->prepare('INSERT INTO  tec_send_invoice_nc VALUES(
		null,
		:note_credit_id,
		:issue_date,
		:file_name,
		:type,
		:flg_response,
		:error_code,
		:response_descrip,
		null,
		:status,
		:user_Create,
		:date_Create,
		null,
		null,
		:estado
		);');
		
		$statement->execute([
			'note_credit_id' => $sendInvoice->getNote_credit_id(),
			'issue_date' => $sendInvoice->getIssue_date(),
			'file_name' => $sendInvoice->getFile_name(),
			'type' => $sendInvoice->getType(),
			'flg_response' => $sendInvoice->getFlg_response(),
			'error_code' => $sendInvoice->getError_code(),
			'response_descrip' => $sendInvoice->getResponse_descrip(),
			'status' => $sendInvoice->getStatus(),
			'user_Create' => $sendInvoice->getUser_Create(),
			'date_Create' => $sendInvoice->getDate_Create(),
			'estado' => $sendInvoice->getEstado()
		]);
		
	}
	
	public function update_invoceNC(NoteCreditModel $note_credit, $datos_emp)
	{
		try{
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
			$statement = $conexion->prepare('UPDATE tec_send_invoice_nc SET
								estado = :estado
							WHERE
								note_credit_id = :note_credit_id
						');
						
			$statement->execute([
				'estado' => "0",
				'note_credit_id' => $note_credit->getId()
			]);
		
		}catch(PDOException $e){
			
		}
			
	}
	
	public function valid_invoiceNC($id): array
	{
		$conexion = Conexao::conectarBd('127.0.0.1',
							'basketperu_db_11111111132',
							'basketperu_u_11111111132',
							'actecaUWI');
		$result = $conexion->query('SELECT 
							estado
						FROM tec_send_invoice_nc 
						WHERE status = 4 and note_credit_id = '.$id.'
					')->fetchAll(\PDO::FETCH_ASSOC);
		
		return $result;
	}
	public function consult_statusNC($id, $datos_emp){
		$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
		$result=$conexion->query(
			"SELECT id,serieNumero FROM tec_credit_note WHERE id=".$id." and (response_descrip not like '%error%' or response_descrip !='') and flg_response=1
			")->fetchAll(\PDO::FETCH_ASSOC);
		if($result){
			return $result;
		}	else{
			return false;
		}
	}
	public function ObtieneItemsCN($id, $datos_emp){
		
		$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
		$result=$conexion->query(
								"SELECT 
								Quantity,
								LineExtensionAmount,
								PricingReference,
								PriceTypeCode,
								TaxTotalTaxAmount,
								TaxSubtotalTaxableAmount,
								PriceAmount,
								TaxSubtotalTaxAmount,
								TaxPercent,
								Description,
								itemSellersID,
								tax_method 
								FROM tec_credit_note_items 
								WHERE credit_note_id=".$id
			)->fetchAll(\PDO::FETCH_ASSOC);
		
			return $result;
		
	}
	
	public function update_NC(array $note_credit, $id)
	{
		try{
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
			$statement = $conexion->prepare('UPDATE tec_credit_note SET
								flg_response = :flg_response,
								error_code = :error_code,
								response_descrip = :response_descrip,
								digest_value = :digest_value,
							WHERE
								id = :id
						');
						
			$statement->execute([
				'flg_response' => $note_credit['flg_response'],
				'error_code' => $note_credit['error_code'],
				'response_descrip' => $note_credit['response_descrip'],
				'digest_value' => $note_credit['digest_value'],
				'id' => $id
			]);
		
		}catch(PDOException $e){
			
		}
			
	}
}

