<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<script>
    $(document).ready(function () {
        $('#MKData').DataTable({
            'bProcessing': true,
            'bServerSide': true,
            "responsive": true,
            "order": [[ 1, "desc" ]],
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "<?= site_url('makers/get_makers') ?>",
            },
            "columns": [
                { "data": "maker" },
                { "data": "actions", className: "text-center" }
            ],
            oLanguage: {
                sZeroRecords: "<center>No se encontraron resultados</center>"
            },
            columnDefs: [
                { orderable: false, targets: -1 }
            ]
        });
    });
</script>


<section class="content">
    <div class="row">
        <div class="col-md-12">
            <div class="form-group">
                <a href="<?= site_url('makers/add'); ?>" class="btn btn-primary"> <i class="fa fa-plus-square"></i> <?= lang('btn_add_maker'); ?></a>
            </div>
        </div>

        <div class="col-xs-12">
            <div class="box" style="border-top: 2.5px solid #004785;">
               
                <div class="box-body">
                    <div class="table-responsive">
                    <table id="MKData" class="table table-bordered table-hover table-striped table-condensed" style="width:100%">
                        <thead>
                        <tr>
                            <th width="80">Fabricante</th>                            
                            <th width="10">Acciones</th>
                        </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td colspan="9" class="dataTables_empty"><?= lang('loading_data_from_server') ?></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script type="text/javascript" src="<?= $assets ?>plugins/datatables/datatable.min.js"></script>
