<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>
<!--Script datatable-->

<!-- DataTable de Productos -->

<script type="text/javascript">
    $(document).ready(function () {
        $('#listados').DataTable({
            "serverSide": true,
            "pageLenght": 10,
            "responsive": true,
            "order": [[ 2, "asc" ]],
            "language": {
                "url": "<?= $assets ?>/dist/js/pages/es_es.lang"
            },
            "displayLength": 25,
            "processing": true,
            "serverSide": true,
            "ajax": {
                "url": "<?= site_url('products/get_products') ?>",
                "dataSrc" : "listados",
            },
            "columns": [
                { "data": "image", "name": "image" },
                { "data": "code", "name": "code" },
                { "data": "name", "name": "name" },
                { "data": "type", "name": "type" },
                { "data": "category_id", "name": "category_id" },
                { "data": "quantity", "name": "quantity"},
                { "data": "tax_method", "name": "tax_method" },
                { "data": "currency", "name": "currency" },
                { "data": "cost", "name": "cost" },
                { "data": "price", "name": "price" },
                <?php if($Admin || $Staff) { ?>
                { "data": "actions", "name": "actions" }
                <?php } ?>

            ],
            columnDefs: [
                { orderable: false, targets: -1 },
                { orderable: false, targets: -2 },
                { orderable: false, targets: -3 },
                { orderable: false, targets: -4 },
                { orderable: false, targets: -5 },
                { orderable: false, targets: -6 },
                { orderable: false, targets: -7 }
            ]


        });
    });
</script>



<section class="content">

    <div class="row">
        
            <div class="col-md-12">
                <div class="box">
                <div class="box-header">
                <?php if($Admin || $Staff) { ?>
                <div class="form-group">
                    <a href="<?= site_url('products/add'); ?>" class="btn btn-primary"> <i class="fa fa-plus-square"></i> <?= lang('btn_new_add_product'); ?></a>
                    <div class="btn btn-sm btn-success col-md-offset-10" onclick="exportTableToExcel()"><i class="fa fa-file-excel-o"></i> Exportar Excel</div>
                </div>
                <?php } ?>
                <hr>
                <div class="box-body" style="padding-top: 0px;">

                    <div class="col-lg-12">
                        <div class="row">

                            <div class="col-md-6">
                                <div class="form-group">
                                    <?= lang('warehouse_s', 'warehouse_s'); ?>
                                        <?php
                                        $sw[''] = lang("select")." ".lang("warehouse_s");
                                        foreach($warehouses as $ware) {
                                            $sw[$ware->id] = $ware->warehouse;
                                        }
                                        ?>
                                        <?= form_dropdown('warehouse', $sw, set_value('warehouse'), 'class="form-control select2 warehouse" id="warehouse"   required="required" style="width:100%;"'); ?>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <?= lang('category', 'category'); ?>
                                    <?php
                                    $categories_list = array();
                                    $categories_list[0] = lang('select_categorie', 'select_categorie');

                                    foreach($categories as $item) {
                                        $categories_list[$item['id']] = $item['name'];
                                    }

                                    ?>

                                    <?= form_dropdown('category', $categories_list, '0', 'class="form-control select2" id="categories" style:"100%;"'); ?>
                                </div>           

                            </div>        

                        </div>
                        <hr>
                        <button type="submit" class="btn btn-success" id="btnSearch"><?= lang("search2")?></button>
                        <button type="submit" class="btn btn-info" id="btnAll"><?= lang("see"). " " . lang("all");?></button>


                    </div>
                </div>

            </div>
            </div>
            </div>

       

        <div class="col-xs-12">
            <div class="box" style="border-top: 2.5px solid #004785;">
                <div class="box-body">
                    <div class="table-responsive">
                        <!--<table id="listados" class="display" style="width:100%">-->
                        <table id="listados" class="table table-bordered table-hover table-striped table-condensed" style="width:100%">
                            <thead>
                                <tr>
                                    <th width="70">Imagen</th>
                                    <th width="70">C&oacute;digo</th>
                                    <th>Nombre</th>
                                    <th>Tipo</th>
                                    <th class="col-xs-1"><?= lang("category"); ?></th>
                                    <th>Cant.</th>
                                    <th>M&eacute;todo</th>
                                    <th>Moneda</th>
                                    <th>P. Costo</th>
                                    <th>P. Venta</th>
                                    <th>Acciones</th>
                                </tr>
                            </thead>
                        </table>
                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>

        <div class="modal fade" id="image_modal" tabindex="-1" role="dialog" aria-labelledby="picModalLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i class="fa fa-times"></i></button>
                        <h4 class="modal-title" id="modal_title">title</h4>
                    </div>
                    <div class="modal-body text-center">
                        <img id="modal_image" src="" alt="" style="width: 20rem;"/>
                    </div>
                </div>
            </div>
        </div>

    </div>
</section>

<!--Script para modal imagen-->

<script type="text/javascript">
$(document).ready(function() {
    $('#listados').on('click', '.image-modal', function() {
        var image = $(this).attr('href');
        var title = $(this).data('title');
        $('#modal_title').text(title);
        $('#modal_image').attr('src',image);
        $('#image_modal').modal();
        return false;
    });

    $('#listados').on('click', '.print-modal', function() {
        var url = $(this).attr('href');
        window.open(url, 'print-popup', 'width=900,height=600,menubar=yes,scrollbars=yes,status=no,resizable=yes,screenx=0,screeny=0');
        return false;
    });
});
</script>

<!--Script para buscar en excel-->

<script>
		function exportTableToExcel() {
			$(".table").table2excel({
				//exclude: "#tableID",
				name: "Excel Document Name",
				filename: "FacsiSoft - Reporte de Productos",
			});
		}
</script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/AlertifyJS/1.13.1/alertify.min.js" integrity="sha512-JnjG+Wt53GspUQXQhc+c4j8SBERsgJAoHeehagKHlxQN+MtCCmFDghX9/AcbkkNRZptyZU4zC8utK59M5L45Iw==" crossorigin="anonymous" referrerpolicy="no-referrer"></script>
<script src="https://cdn.datatables.net/1.10.23/js/jquery.dataTables.min.js" type="text/javascript"></script>
<script type="text/javascript" src="<?= $assets ?>plugins/datatables/datatable.min.js"></script>
