<?php (defined('BASEPATH')) OR exit('No direct script access allowed'); ?>

<section class="content">
    <div class="row">
        <div class="col-xs-12">
            <div class="box" style="border-top: 2.5px solid #9fc10b;">
                <!-- <div class="box-header">
                    <h3 class="box-title"><?= lang('enter_info'); ?></h3>
                </div> -->
                <div class="box-body">
                    <div class="col-lg-12">
                        <?php
                        $attrib = array('class' => 'validation', 'role' => 'form');

                        echo form_open("warehouses/add", $attrib); ?>
                        <div class="row">
                            <div class="col-lg-1 col-md-2">
                                <div class="form-group">
                                    <?= lang("warehouse_code", "warehouse_code"); ?>
                                    <?php echo form_input('warehouse_code', '', 'class="form-control" id="warehouse_code" required="required" maxlength="10"'); ?>
                                </div>
                            </div>
                            <div class="col-lg-11 col-md-10">
                                <div class="form-group">
                                    <?= lang("warehouse_name", "warehouse_name"); ?>
                                    <?php echo form_input('warehouse_name', '', 'class="form-control" id="warehouse_name" required="required" maxlength="250"'); ?>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <?= lang("warehouse_address", "warehouse_address"); ?>
                                    <?php echo form_input('warehouse_address', '', 'class="form-control" id="warehouse_address" required="required" maxlength="200"'); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?= lang("warehouse_department", "warehouse_department"); ?>
                                    <?php echo form_dropdown('warehouse_department', $departamentList, '1', 'class="form-control" id="warehouse_department" onclick="javascript:loadProvinceWarehouse();" required="required"'); ?>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?= lang("warehouse_province", "warehouse_province"); ?>
                                    <select class="form-control" name="warehouse_province" id="warehouse_province" onclick="javascript:loadDistrictWarehouse();">
                                        <option>SELECCIONAR</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <?= lang("warehouse_district", "warehouse_district"); ?>
                                    <select class="form-control" name="warehouse_district" id="warehouse_district" required="required">
                                        <option value="">SELECCIONAR</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <fieldset class="warehouse-border">
                                    <legend class="warehouse-border"><?= lang("warehouse_external_guide", "warehouse_external_guide"); ?></legend>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?= lang("warehouse_external_guide_serie", "warehouse_external_guide_serie"); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?php echo form_input('warehouse_external_guide_serie', '', 'class="form-control input-alpha" id="warehouse_external_guide_serie" required="required" maxlength="4"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?= lang("warehouse_external_guide_number", "warehouse_external_guide_number"); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?php echo form_input('warehouse_external_guide_number', '', 'class="form-control input-number" id="warehouse_external_guide_number" required="required" maxlength="8"'); ?>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                            <div class="col-md-6">
                                <fieldset class="warehouse-border">
                                    <legend class="warehouse-border"><?= lang("warehouse_internal_guide", "warehouse_internal_guide"); ?></legend>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?= lang("warehouse_internal_guide_serie", "warehouse_internal_guide_serie"); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?php echo form_input('warehouse_internal_guide_serie', '', 'class="form-control input-alpha" id="warehouse_internal_guide_serie" required="required" maxlength="4"'); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?= lang("warehouse_internal_guide_number", "warehouse_internal_guide_number"); ?>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <?php echo form_input('warehouse_internal_guide_number', '', 'class="form-control input-number" id="warehouse_internal_guide_number" required="required" maxlength="8"'); ?>
                                        </div>
                                    </div>
                                </fieldset>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <?= form_submit('add_warehouse', lang('btn_add_warehouse'), 'class="btn btn-primary"'); ?>
                                </div>
                            </div>
                        </div>
                        <?php echo form_close(); ?>

                    </div>
                    <div class="clearfix"></div>
                </div>
            </div>
        </div>
    </div>
</section>
<script src="https://code.jquery.com/ui/1.12.1/jquery-ui.js"></script>
<script src="<?= $assets ?>dist/js/pages/Warehouses.js" type="text/javascript"></script>

<script src="<?= $assets ?>plugins/input-mask/jquery.inputmask.js" type="text/javascript"></script>
<script src="<?= $assets ?>plugins/input-mask/jquery.inputmask.date.extensions.js" type="text/javascript"></script>