var client = require('./client')
  , owner = require('./owner')
  , noop = require('./noop')

module.exports = function group(prefix, fn){
  if (!owner.console) return fn()
  if (!console.groupCollapsed) polyfill()
  console.groupCollapsed(prefix)
  var ret = fn()
  console.groupEnd(prefix)
  return ret
}

function polyfill() {
  console.groupCollapsed = console.groupEnd = function(d){
    (console.log || noop)('*****', d, '*****')
  }
}