var debounce = require('./debounce')
  , through = require('through')
  , noop = require('./noop')

module.exports = function via(fn){
  var stream = through(write, noop)
    , once = debounce(push)
    , buffer = ''

  return stream

  function write(chunk){
    buffer += chunk
    once()
  }

  function push(){ 
    stream.push(fn(buffer.toString())) 
  }
}