//VARIABLES PARA LISTAR
let model = "Cliente";
let endpoint = "/clients";
let table = "table-client";
let columns = [
    { data: "documento" },
    { data: "razon_social" },
    { data: "direccion" },
    { data: "sub_dominio" },
    { data: "fec_afiliacion" },
    { data: "fec_suspencion" },
    { data: "fec_cancelacion" },
    {
        data: null,
        render: function (data, type, row) {
            let style = "";
            let title = "";
            if (data.estado == 'ACTIVO') {
                style = "btn-success";
                title = "Activo";
                //style = "badge-danger";
                //title = "Activo";
            }else if(data.estado == 'SUSPENDIDO'){
                style = "btn-warning";
                title = "Suspendido";
            }else if(data.estado == 'DE BAJA'){
                style = "btn-danger";
                title = "De baja";
            }
            return `<span class="badge ${style}">${title}</span>`;
        },
    },

    {
        data: null,
        render: function (data, type, row) {

            let icon = "fas fa-times";
            let style = "btn-danger";
            let title = "Desactivar";
            if (data.active == 0) {
                icon = "fas fa-check";
                style = "btn-success";
                title = "Activar";
            }
            return `<div class="buttons">
                        <button type="button" class="btn btn-icon btn-sm btn-primary">
                            <i class="fas fa-edit"></i>
                        </button>
                    </div>`;
        },
    },

];

let columns_export = [0, 1, 2, 3, 4, 5, 6, 7];

//Iniciar
const init = () => {
    //LISTAR TABLA
    if (document.getElementById(table)) {
        listTable();
    }
};

//LISTAR
const listTable = async () => {
    //Obtenemos la ruta ajax.
    //let url = document.getElementById(table).getAttribute("data-ajax");
    const token = sessionStorage.getItem('token');
    const route = `${endpointWS}/empresas?api_token=${token}`;
    //Hacer Request
    const response = await requestAxios(route, "GET", {});
    //console.log(response);

    listarDatatableWs(response.data.data, table, columns, columns_export);

};

init();