
const formLogin = "form-login";


//Iniciar
const init = () => {
    //CLICK EN EL BOTON SOLICITAR
    if (document.getElementById("btn-login")) {
        document
            .getElementById("btn-login")
            .addEventListener("click", login);
    }
};

//Cuando seleccionan categoria
const login = async (event) => {
    event.preventDefault();
    //Validaciones
    if (!validation()) {
        return false;
    }
    // //Desabilitamos el boton
    document.getElementById("btn-login").disabled = true;
    //Agregamos un loading
    loading();
    //Data del formulario
    let myForm = document.getElementById(formLogin);
    let data = new FormData(myForm);
    //Obtenemos la ruta donde debe ir los datos del formulario.
    let route = `${endpointWS}/inicio_session`;
    //Hacer Request
    const response = await requestAxios(route, "POST", data);
    //Cerramos Loading
    Swal.close();
    //Habilitamos el boton
    document.getElementById("btn-login").disabled = false;
    if (response.status === 201 || response.status === 200) {
        if(!response.data.res){
            notification(
                "error",
                "Advertencia!",
                "Cuenta o password incorrectos."
            );
            return false;
        }
        const { token } = response.data;
        guardarToken(token);
        //GUARDAR INFORMACION PERFIL
        guardarInformacionPerfil();
        //Redireccionar a Home
        window.location.href = "/home";
    } else if (response.status === 422) {
        validationError(response.data.errors);
    } else if (error.response.status === 403) {
        notification(
            "warning",
            "Advertencia!",
            "Usted no tiene permiso para esta acción."
        );
    } else if (response.status === 419) {
        notification(
            "warning",
            "Advertencia!",
            "Sesion Terminada."
        );
        location.reload();
    } else {
        anyError();
    }

}


const validation = () => {
    let email = document.getElementById("email").value;
    let password = document.getElementById("password").value;

    if (email == "") {
        notification(
            "warning",
            "Advertencia!",
            "Debe ingresar email."
        );
        return false;
    }
    if (password == "") {
        notification("warning", "Advertencia!", "Debe ingresar password.");
        return false;
    }
    return true;
}

const guardarToken = (token) => {
    sessionStorage.setItem("token", token);
}

const guardarInformacionPerfil = async () => {
    const token = sessionStorage.getItem('token');
    if (token) {
        //Obtenemos la ruta donde debe ir los datos del formulario.
        let route = `${endpointWS}/user?api_token=${token}`;
        //Hacer Request
        const response = await requestAxios(route, "GET", {});
        if (response.status === 201 || response.status === 200) {
            //const { id, level,  } = response.data;
            guardarObjetoPerfil(response.data);
        }
    } else {
        //Redireccionar a Login
        window.location.href = "/login";
    }
}

const guardarObjetoPerfil = (data) => {
    sessionStorage.setItem("user", JSON.stringify(data));
}

/* const validateToken = () => {
    const token = sessionStorage.getItem('token');
    if (token) {
        window.location.href = "/home";
    }
} */


init();