@extends('layouts.app_admin', ['activePage' => 'client', 'title' => 'Clientes'])

@push('styles-library')
    @include('layouts.shared.css_datatable')
@endpush

@section('content')
    <section class="section">
        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h4>Listado de Clientes</h4>
                        </div>
                        <div class="card-body">

                            <div class="row">
                                <div class="text-end">
                                    <button class="btn btn-icon icon-left btn-info pull-right" id="btnModalAddRole">
                                        <i class="fas fa-plus"> Agregar Cliente</i>
                                    </button>
                                </div>
                            </div>

                            <div class="table-responsive">
                                <table id="table-client" class="table table-striped table-hover" style="width:100%;">
                                    <thead>
                                        <tr>
                                            <th>RUC</th>
                                            <th>Razon Social</th>
                                            <th>Direccion</th>
                                            <th>Sub-dominio</th>
                                            <th>Fecha Registro</th>
                                            <th>Ultimo Pago</th>
                                            <th>Corte</th>
                                            <th>Estado</th>
                                            <th>Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    {{-- @include('admin.pages.config.roles.modal') --}}
@endsection


@push('scripts-custom')
    @include('layouts.shared.script_datatable')
    <!-- JS Personalizado -->
    <script src="{{ asset('js/admin/aplication/client.js') }}"></script>
@endpush
