<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>FacsiSoft | Login</title>
    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Nunito" rel="stylesheet">

    <link rel="shortcut icon" href="<?php echo e(asset('metch')); ?>/media/logos/iconoFSFT.png">

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">
    <script>
        const token = sessionStorage.getItem('token');
        if (token) {
            window.location.href = "/home";
        }
    </script>
</head>

<body>
    <div id="app">
        <main class="py-4">
            <div id="app">
                <section class="section">
                    <div class="container mt-5">
                        <div class="row justify-content-center">
                            <div class="col-md-6 offset-md-3">
                                <div class="login-brand">
                                    <img src="<?php echo e(asset('img/logo.png')); ?>" alt="logo" width="250"
                                        class="shadow-light">
                                </div>

                            </div>
                        </div>
                    </div>
                </section>
            </div>
            <br>
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-6">
                        <div class="card card-primary">
                            <div class="card-header">Iniciar Sesión como Admistrador</div>
                            <div class="card-body">
                                <form id="form-login" autocomplete="off">
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <input id="email" type="email" placeholder="E-mail"
                                                class="form-control" name="email" required autofocus>
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <div class="col-md-12">
                                            <input id="password" type="password" placeholder="Password"
                                                class="form-control" name="password" required>
                                        </div>
                                    </div>
                                    <div class="form-group row mb-0">
                                        <div class="col-md-12">
                                            <button type="button" class="btn btn-primary" id="btn-login">
                                                Ingresar
                                            </button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </main>
    </div>
</body>

<!-- Mix Js -->
<script src="<?php echo e(asset('js/app.js')); ?>"></script>
<!-- JS Personalizado -->
<script src="<?php echo e(asset('js/admin/auth/login.js')); ?>"></script>


</html>
<?php /**PATH D:\xampp\htdocs\web-facsisoft-administrador\resources\views/admin/pages/auth/login.blade.php ENDPATH**/ ?>